/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.stats;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.search.solr8.internal.stats.StatsTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsResponse;
import com.liferay.portal.search.stats.StatsResponseBuilder;
import com.liferay.portal.search.stats.StatsResponseBuilderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StatsTranslator.class})
public class DefaultStatsTranslator
implements StatsTranslator {
    @Reference
    private StatsResponseBuilderFactory _statsResponseBuilderFactory;

    @Override
    public void populateRequest(SolrQuery solrQuery, StatsRequest statsRequest) {
        ArrayList<String> solrStats = new ArrayList<String>(9);
        if (statsRequest.isCardinality()) {
            solrStats.add("cardinality");
        }
        if (statsRequest.isCount()) {
            solrStats.add("count");
        }
        if (statsRequest.isMax()) {
            solrStats.add("max");
        }
        if (statsRequest.isMean()) {
            solrStats.add("mean");
        }
        if (statsRequest.isMin()) {
            solrStats.add("min");
        }
        if (statsRequest.isMissing()) {
            solrStats.add("missing");
        }
        if (statsRequest.isStandardDeviation()) {
            solrStats.add("stddev");
        }
        if (statsRequest.isSum()) {
            solrStats.add("sum");
        }
        if (statsRequest.isSumOfSquares()) {
            solrStats.add("sumOfSquares");
        }
        if (solrStats.isEmpty()) {
            return;
        }
        String fieldStatistics = this.buildField(statsRequest.getField(), solrStats);
        solrQuery.setGetFieldStatistics(fieldStatistics);
    }

    @Override
    public StatsResponse translateResponse(FieldStatsInfo fieldStatsInfo) {
        StatsResponseBuilder statsResponseBuilder = this._statsResponseBuilderFactory.getStatsResponseBuilder();
        String field = fieldStatsInfo.getName();
        statsResponseBuilder.field(field);
        DefaultStatsTranslator.copy(() -> ((FieldStatsInfo)fieldStatsInfo).getCardinality(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).cardinality(arg_0));
        DefaultStatsTranslator.copy(() -> ((FieldStatsInfo)fieldStatsInfo).getCount(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).count(arg_0));
        DefaultStatsTranslator.copy(() -> ((FieldStatsInfo)fieldStatsInfo).getMissing(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).missing(arg_0));
        DefaultStatsTranslator.copy(() -> ((FieldStatsInfo)fieldStatsInfo).getStddev(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).standardDeviation(arg_0));
        DefaultStatsTranslator.copy(() -> ((FieldStatsInfo)fieldStatsInfo).getSumOfSquares(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).sumOfSquares(arg_0));
        DefaultStatsTranslator.copyDouble(() -> ((FieldStatsInfo)fieldStatsInfo).getMax(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).max(arg_0));
        DefaultStatsTranslator.copyDouble(() -> ((FieldStatsInfo)fieldStatsInfo).getMean(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).mean(arg_0));
        DefaultStatsTranslator.copyDouble(() -> ((FieldStatsInfo)fieldStatsInfo).getMin(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).min(arg_0));
        DefaultStatsTranslator.copyDouble(() -> ((FieldStatsInfo)fieldStatsInfo).getSum(), arg_0 -> ((StatsResponseBuilder)statsResponseBuilder).sum(arg_0));
        return statsResponseBuilder.build();
    }

    protected static <T> void copy(Supplier<T> from, Consumer<T> to) {
        T t = from.get();
        if (t != null) {
            to.accept(t);
        }
    }

    protected static void copyDouble(Supplier<?> from, Consumer<Double> to) {
        Object t = from.get();
        if (t != null) {
            to.accept(DefaultStatsTranslator.toDouble(t));
        }
    }

    protected static double toDouble(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new IllegalArgumentException("Only numeric fields are supported");
    }

    protected String buildField(String field, List<String> solrStats) {
        if (solrStats.isEmpty()) {
            return field;
        }
        StringBundler sb = new StringBundler(solrStats.size() * 3 + 3);
        sb.append("{!");
        for (int i = 0; i < solrStats.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(solrStats.get(i));
            sb.append("=true");
        }
        sb.append("}");
        sb.append(field);
        return sb.toString();
    }
}

