/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.sort;

import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.GeoDistanceSort;
import com.liferay.portal.search.sort.ScoreSort;
import com.liferay.portal.search.sort.ScriptSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldTranslator;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.SortVisitor;
import org.apache.solr.client.solrj.SolrQuery;
import org.osgi.service.component.annotations.Component;

@Component(service={SolrSortFieldTranslator.class})
public class SolrSortFieldTranslator
implements SortFieldTranslator<SolrQuery.SortClause>,
SortVisitor<SolrQuery.SortClause> {
    public SolrQuery.SortClause translate(Sort sort) {
        return (SolrQuery.SortClause)sort.accept((SortVisitor)this);
    }

    public SolrQuery.SortClause visit(FieldSort fieldSort) {
        SolrQuery.ORDER order = SolrQuery.ORDER.asc;
        if (SortOrder.DESC.equals((Object)fieldSort.getSortOrder())) {
            order = SolrQuery.ORDER.desc;
        }
        return SolrQuery.SortClause.create((String)fieldSort.getField(), (SolrQuery.ORDER)order);
    }

    public SolrQuery.SortClause visit(GeoDistanceSort geoDistanceSort) {
        throw new UnsupportedOperationException();
    }

    public SolrQuery.SortClause visit(ScoreSort scoreSort) {
        SolrQuery.ORDER order = SolrQuery.ORDER.desc;
        if (SortOrder.ASC.equals((Object)scoreSort.getSortOrder())) {
            order = SolrQuery.ORDER.asc;
        }
        return new SolrQuery.SortClause("score", order);
    }

    public SolrQuery.SortClause visit(ScriptSort scriptSort) {
        throw new UnsupportedOperationException();
    }
}

