/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.legacy.groupby.GroupByRequestFactory;
import com.liferay.portal.search.legacy.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.solr8.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.BaseSolrQueryAssembler;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.SearchSolrQueryAssembler;
import com.liferay.portal.search.solr8.internal.sort.SolrSortFieldTranslator;
import com.liferay.portal.search.solr8.internal.stats.StatsTranslator;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.client.solrj.SolrQuery;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSolrQueryAssembler.class})
public class SearchSolrQueryAssemblerImpl
implements SearchSolrQueryAssembler {
    @Reference
    private BaseSolrQueryAssembler _baseSolrQueryAssembler;
    @Reference
    private GroupByRequestFactory _groupByRequestFactory;
    @Reference
    private GroupByTranslator _groupByTranslator;
    @Reference
    private SolrSortFieldTranslator _sortFieldTranslator;
    @Reference
    private StatsRequestBuilderFactory _statsRequestBuilderFactory;
    @Reference
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        this._baseSolrQueryAssembler.assemble(solrQuery, (BaseSearchRequest)searchSearchRequest);
        this.setGroupBy(solrQuery, searchSearchRequest);
        this.setGroupByRequests(solrQuery, searchSearchRequest);
        this.setHighlights(solrQuery, searchSearchRequest);
        this.setIncludeScore(solrQuery, searchSearchRequest);
        this.setPagination(solrQuery, searchSearchRequest);
        this.setSelectedFields(solrQuery, searchSearchRequest);
        this.setSorts(solrQuery, searchSearchRequest);
        this.setStats(solrQuery, searchSearchRequest);
    }

    protected void addHighlightedField(SolrQuery solrQuery, Locale locale, String fieldName) {
        solrQuery.addHighlightField(fieldName);
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        solrQuery.addHighlightField(localizedFieldName);
    }

    protected SolrQuery.SortClause getFieldSortClause(Sort sort, String fieldName) {
        if (sort.isReverse()) {
            return SolrQuery.SortClause.desc((String)fieldName);
        }
        return SolrQuery.SortClause.asc((String)fieldName);
    }

    protected SolrQuery.SortClause getScoreSortClause(Sort sort) {
        if (sort.isReverse()) {
            return SolrQuery.SortClause.asc((String)"score");
        }
        return SolrQuery.SortClause.desc((String)"score");
    }

    protected SolrQuery.SortClause getSortClause(Sort sort, String fieldName) {
        if (fieldName.equals("score")) {
            return this.getScoreSortClause(sort);
        }
        return this.getFieldSortClause(sort, fieldName);
    }

    protected String getSortFieldName(Sort sort, String scoreFieldName) {
        String sortFieldName = sort.getFieldName();
        if (Objects.equals(sortFieldName, "priority") || Objects.equals(sortFieldName, "score")) {
            return sortFieldName;
        }
        return Field.getSortFieldName((Sort)sort, (String)scoreFieldName);
    }

    protected void setGroupBy(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        GroupBy groupBy = searchSearchRequest.getGroupBy();
        if (groupBy != null) {
            this._groupByTranslator.translate(solrQuery, this._groupByRequestFactory.getGroupByRequest(groupBy), searchSearchRequest.getLocale(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize());
        }
    }

    protected void setGroupByRequests(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        List groupByRequests = searchSearchRequest.getGroupByRequests();
        if (ListUtil.isNotEmpty((List)groupByRequests)) {
            this._groupByTranslator.translate(solrQuery, (GroupByRequest)groupByRequests.get(0), searchSearchRequest.getLocale(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize());
        }
    }

    protected void setHighlights(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        if (!searchSearchRequest.isHighlightEnabled()) {
            return;
        }
        solrQuery.setHighlight(true);
        solrQuery.setHighlightFragsize(searchSearchRequest.getHighlightFragmentSize());
        solrQuery.setHighlightSimplePost("</liferay-hl>");
        solrQuery.setHighlightSimplePre("<liferay-hl>");
        solrQuery.setHighlightSnippets(searchSearchRequest.getHighlightSnippetSize());
        for (String highlightFieldName : searchSearchRequest.getHighlightFieldNames()) {
            this.addHighlightedField(solrQuery, searchSearchRequest.getLocale(), highlightFieldName);
        }
        if (!searchSearchRequest.isLuceneSyntax()) {
            solrQuery.setHighlightRequireFieldMatch(searchSearchRequest.isHighlightRequireFieldMatch());
        }
    }

    protected void setIncludeScore(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        solrQuery.setIncludeScore(searchSearchRequest.isScoreEnabled());
    }

    protected void setPagination(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        GroupBy groupBy = searchSearchRequest.getGroupBy();
        if (groupBy != null || ListUtil.isNotEmpty((List)searchSearchRequest.getGroupByRequests())) {
            return;
        }
        solrQuery.setRows(searchSearchRequest.getSize());
        solrQuery.setStart(searchSearchRequest.getStart());
    }

    protected void setSelectedFields(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.isAllFieldsSelected()) {
            return;
        }
        Set selectedFieldNames = SetUtil.fromArray((Object[])searchSearchRequest.getSelectedFieldNames());
        if (!selectedFieldNames.contains("uid")) {
            selectedFieldNames.add("uid");
        }
        solrQuery.setFields(selectedFieldNames.toArray(new String[0]));
    }

    protected void setSorts(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        List sorts = searchSearchRequest.getSorts();
        for (com.liferay.portal.search.sort.Sort sort : sorts) {
            solrQuery.addSort(this._sortFieldTranslator.translate(sort));
        }
        Object[] sorts71 = searchSearchRequest.getSorts71();
        if (ArrayUtil.isEmpty((Object[])sorts71)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>();
        for (Object sort : sorts71) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = this.getSortFieldName((Sort)sort, "score"))) continue;
            sortFieldNames.add(sortFieldName);
            solrQuery.addSort(this.getSortClause((Sort)sort, sortFieldName));
        }
    }

    protected void setStats(SolrQuery solrQuery, SearchSearchRequest searchSearchRequest) {
        Map statsMap = searchSearchRequest.getStats();
        if (MapUtil.isNotEmpty((Map)statsMap)) {
            for (Stats stats : statsMap.values()) {
                StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder(stats);
                this._statsTranslator.populateRequest(solrQuery, statsRequestBuilder.build());
            }
        }
    }
}

