/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.SearchSearchRequestExecutor;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.SearchSolrQueryAssembler;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchRequestExecutor.class})
public class SearchSearchRequestExecutorImpl
implements SearchSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(SearchSearchRequestExecutorImpl.class);
    @Reference
    private SearchSearchResponseAssembler _searchSearchResponseAssembler;
    @Reference
    private SearchSolrQueryAssembler _searchSolrQueryAssembler;
    @Reference
    private SolrClientManager _solrClientManager;

    @Override
    public SearchSearchResponse execute(SearchSearchRequest searchSearchRequest) {
        SolrQuery solrQuery = new SolrQuery();
        this._searchSolrQueryAssembler.assemble(solrQuery, searchSearchRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search query: " + this._getDebugRequestString(solrQuery.toString())));
        }
        QueryResponse queryResponse = this.getQueryResponse(new QueryRequest((SolrParams)solrQuery), searchSearchRequest.getIndexNames());
        SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
        this._searchSearchResponseAssembler.assemble(searchSearchResponse, solrQuery, queryResponse, searchSearchRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime(), " ms"}));
        }
        return searchSearchResponse;
    }

    protected QueryResponse getQueryResponse(QueryRequest queryRequest, String[] indexNames) {
        try {
            queryRequest.setMethod(SolrRequest.METHOD.POST);
            return (QueryResponse)queryRequest.process(this._solrClientManager.getSolrClient(), indexNames[0]);
        }
        catch (Exception exception) {
            if (exception instanceof SolrException) {
                SolrException solrException = (SolrException)exception;
                throw solrException;
            }
            throw new RuntimeException(exception);
        }
    }

    private String _getDebugRequestString(String requestString) {
        requestString = URLCodec.decodeURL((String)requestString);
        requestString = StringUtil.replace((String)requestString, (char)'&', (String)"\n&");
        return requestString;
    }
}

