/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.BaseSearchResponseAssembler;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.BaseSolrQueryAssembler;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.CountSearchRequestExecutor;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CountSearchRequestExecutor.class})
public class CountSearchRequestExecutorImpl
implements CountSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(CountSearchRequestExecutorImpl.class);
    @Reference
    private BaseSearchResponseAssembler _baseSearchResponseAssembler;
    @Reference
    private BaseSolrQueryAssembler _baseSolrQueryAssembler;
    @Reference
    private SolrClientManager _solrClientManager;

    @Override
    public CountSearchResponse execute(CountSearchRequest countSearchRequest) {
        SolrQuery solrQuery = new SolrQuery();
        this._baseSolrQueryAssembler.assemble(solrQuery, (BaseSearchRequest)countSearchRequest);
        solrQuery.setRows(Integer.valueOf(0));
        String requestString = solrQuery.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search query " + requestString));
        }
        QueryResponse queryResponse = this.getQueryResponse(new QueryRequest((SolrParams)solrQuery), countSearchRequest.getIndexNames());
        CountSearchResponse countSearchResponse = new CountSearchResponse();
        this._baseSearchResponseAssembler.assemble((BaseSearchResponse)countSearchResponse, solrQuery, queryResponse, (BaseSearchRequest)countSearchRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", countSearchResponse.getSearchRequestString(), " in ", countSearchResponse.getExecutionTime(), " ms"}));
        }
        SolrDocumentList solrDocumentList = queryResponse.getResults();
        countSearchResponse.setCount(solrDocumentList.getNumFound());
        return countSearchResponse;
    }

    protected QueryResponse getQueryResponse(QueryRequest queryRequest, String[] indexNames) {
        try {
            queryRequest.setMethod(SolrRequest.METHOD.POST);
            return (QueryResponse)queryRequest.process(this._solrClientManager.getSolrClient(), indexNames[0]);
        }
        catch (Exception exception) {
            if (exception instanceof SolrException) {
                SolrException solrException = (SolrException)exception;
                throw solrException;
            }
            throw new RuntimeException(exception);
        }
    }
}

