/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.search;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.solr8.internal.AggregationFilteringFacetProcessorContext;
import com.liferay.portal.search.solr8.internal.FacetProcessorContext;
import com.liferay.portal.search.solr8.internal.facet.FacetProcessor;
import com.liferay.portal.search.solr8.internal.facet.FacetUtil;
import com.liferay.portal.search.solr8.internal.filter.FilterTranslator;
import com.liferay.portal.search.solr8.internal.query.translator.SolrQueryTranslator;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.BaseSolrQueryAssembler;
import com.liferay.portal.search.solr8.internal.stats.StatsTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrQuery;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={BaseSolrQueryAssembler.class})
public class BaseSolrQueryAssemblerImpl
implements BaseSolrQueryAssembler {
    private final FacetProcessor<SolrQuery> _defaultFacetProcessor = new FacetProcessor<SolrQuery>(){

        @Override
        public Map<String, JSONObject> processFacet(Facet facet) {
            return LinkedHashMapBuilder.put((Object)FacetUtil.getAggregationName(facet), (Object)this._getFacetParametersJSONObject(facet)).build();
        }

        private JSONObject _getFacetParametersJSONObject(Facet facet) {
            FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
            JSONObject dataJSONObject = facetConfiguration.getData();
            return JSONUtil.put((String)"field", (Object)facet.getFieldName()).put("limit", () -> {
                int limit = dataJSONObject.getInt("maxTerms");
                if (limit > 0) {
                    return limit;
                }
                return null;
            }).put("mincount", () -> {
                int minCount = dataJSONObject.getInt("frequencyThreshold");
                if (minCount > 0) {
                    return minCount;
                }
                return null;
            }).put("sort", () -> {
                String order = facetConfiguration.getOrder();
                if (order.equals("OrderValueAsc")) {
                    return JSONUtil.put((String)"index", (Object)"asc");
                }
                return JSONUtil.put((String)"count", (Object)"desc");
            }).put("type", "terms");
        }
    };
    @Reference(target="(search.engine.impl=Solr)")
    private FilterTranslator<String> _filterTranslator;
    @Reference(target="(search.engine.impl=Solr)")
    private QueryTranslator<String> _queryTranslator;
    private ServiceTrackerMap<String, FacetProcessor> _serviceTrackerMap;
    private final SolrQueryTranslator _solrQueryTranslator = new SolrQueryTranslator();
    @Reference
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SolrQuery solrQuery, BaseSearchRequest baseSearchRequest) {
        this.setExplain(solrQuery, baseSearchRequest);
        this.setFacets(solrQuery, baseSearchRequest);
        this.setFilterQueries(solrQuery, baseSearchRequest);
        this.setQuery(solrQuery, baseSearchRequest);
        this.setStatsRequests(solrQuery, baseSearchRequest);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FacetProcessor.class, (String)"(&(class.name=*)(!(class.name=DEFAULT)))", (serviceReference, emitter) -> {
            List classNames = StringUtil.asList((Object)serviceReference.getProperty("class.name"));
            for (String className : classNames) {
                emitter.emit((Object)className);
            }
        });
    }

    protected void addFilterQuery(List<String> filterQueries, Facet facet, String tag) {
        BooleanClause booleanClause = facet.getFacetFilterBooleanClause();
        if (booleanClause == null) {
            return;
        }
        String filterString = this.translate((BooleanClause<Filter>)booleanClause);
        filterQueries.add(StringBundler.concat((String[])new String[]{"{!tag=", tag, "}", filterString}));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void excludeTags(Map<String, JSONObject> map, String excludeTagsString) {
        for (JSONObject jsonObject : map.values()) {
            jsonObject.put("excludeTags", excludeTagsString);
        }
    }

    protected String getExcludeTagsString(String tag, FacetProcessorContext facetProcessorContext) {
        String excludeTagsString = facetProcessorContext.getExcludeTagsString();
        if (excludeTagsString == null) {
            return tag;
        }
        return excludeTagsString;
    }

    protected String getFacetString(Map<String, JSONObject> jsonObjects) {
        Set<Map.Entry<String, JSONObject>> entrySet = jsonObjects.entrySet();
        StringBundler sb = new StringBundler(2 * entrySet.size() + 1);
        sb.append("{");
        for (Map.Entry<String, JSONObject> entry : entrySet) {
            sb.append(StringBundler.concat((Object[])new Object[]{"\"", entry.getKey(), "\"", ":", entry.getValue()}));
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("}");
        return sb.toString();
    }

    protected String getQueryString(BaseSearchRequest baseSearchRequest) {
        Query query = baseSearchRequest.getQuery();
        if (query != null) {
            return this._solrQueryTranslator.translate(query);
        }
        com.liferay.portal.kernel.search.Query legacyQuery = baseSearchRequest.getQuery71();
        if (legacyQuery != null) {
            return (String)this._queryTranslator.translate(legacyQuery, null);
        }
        return null;
    }

    protected void setExplain(SolrQuery solrQuery, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.isExplain()) {
            solrQuery.setShowDebugInfo(true);
        }
    }

    protected void setFacets(SolrQuery solrQuery, BaseSearchRequest baseSearchRequest) {
        Map facets = baseSearchRequest.getFacets();
        LinkedHashMap<String, JSONObject> jsonObjects = new LinkedHashMap<String, JSONObject>();
        ArrayList<String> postFilterQueries = new ArrayList<String>();
        FacetProcessorContext facetProcessorContext = AggregationFilteringFacetProcessorContext.newInstance(facets, baseSearchRequest.isBasicFacetSelection());
        for (Facet facet : facets.values()) {
            if (facet.isStatic()) continue;
            String tag = FacetUtil.getAggregationName(facet);
            this.addFilterQuery(postFilterQueries, facet, tag);
            Map<String, JSONObject> facetParameters = this._getFacetParameters(facet);
            this.excludeTags(facetParameters, this.getExcludeTagsString(tag, facetProcessorContext));
            jsonObjects.putAll(facetParameters);
        }
        if (!jsonObjects.isEmpty()) {
            solrQuery.add("json.facet", new String[]{this.getFacetString(jsonObjects)});
        }
        if (!postFilterQueries.isEmpty()) {
            solrQuery.setFilterQueries(ArrayUtil.toStringArray(postFilterQueries));
        }
    }

    protected void setFilterQueries(SolrQuery solrQuery, BaseSearchRequest baseSearchRequest) {
        ArrayList<String> filterQueries = new ArrayList<String>();
        com.liferay.portal.kernel.search.Query query = baseSearchRequest.getQuery71();
        if (query != null) {
            this._add(filterQueries, (Filter)query.getPreBooleanFilter());
            this._add(filterQueries, query.getPostFilter());
            if (query instanceof BooleanQuery) {
                this._add(filterQueries, (BooleanQuery)query);
            }
        }
        this._addAll(filterQueries, solrQuery.getFilterQueries());
        if (!filterQueries.isEmpty()) {
            solrQuery.setFilterQueries(filterQueries.toArray(new String[0]));
            if (Validator.isBlank((String)solrQuery.getQuery())) {
                solrQuery.setQuery("*:*");
            }
        }
    }

    protected void setQuery(SolrQuery solrQuery, BaseSearchRequest baseSearchRequest) {
        String queryString = this.getQueryString(baseSearchRequest);
        if (!Validator.isBlank((String)queryString)) {
            solrQuery.setQuery(queryString);
        }
    }

    protected void setStatsRequests(SolrQuery solrQuery, BaseSearchRequest baseSearchRequest) {
        for (StatsRequest statsRequest : baseSearchRequest.getStatsRequests()) {
            this._statsTranslator.populateRequest(solrQuery, statsRequest);
        }
    }

    protected String translate(BooleanClause<Filter> booleanClause) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add((Filter)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
        return this._filterTranslator.translate((Filter)booleanFilter);
    }

    private void _add(Collection<String> filterQueries, BooleanQuery booleanQuery) {
        for (BooleanClause booleanClause : booleanQuery.clauses()) {
            com.liferay.portal.kernel.search.Query booleanClauseQuery = (com.liferay.portal.kernel.search.Query)booleanClause.getClause();
            this._add(filterQueries, (Filter)booleanClauseQuery.getPreBooleanFilter());
            if (!(booleanClauseQuery instanceof BooleanQuery)) continue;
            this._add(filterQueries, (BooleanQuery)booleanClauseQuery);
        }
    }

    private void _add(Collection<String> filterQueries, Filter filter) {
        if (filter != null) {
            filterQueries.add(this._filterTranslator.translate(filter));
        }
    }

    private void _addAll(List<String> filterQueries, String[] facetPostFilterQueries) {
        if (!ArrayUtil.isEmpty((Object[])facetPostFilterQueries)) {
            Collections.addAll(filterQueries, facetPostFilterQueries);
        }
    }

    private Map<String, JSONObject> _getFacetParameters(Facet facet) {
        Class<?> clazz = facet.getClass();
        FacetProcessor<SolrQuery> facetProcessor = (FacetProcessor<SolrQuery>)this._serviceTrackerMap.getService((Object)clazz.getName());
        if (facetProcessor == null) {
            facetProcessor = this._defaultFacetProcessor;
        }
        return facetProcessor.processFacet(facet);
    }
}

