/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.search.BaseSearchResponseAssembler;
import com.liferay.portal.search.solr8.internal.stats.StatsTranslator;
import com.liferay.portal.search.stats.StatsResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BaseSearchResponseAssembler.class})
public class BaseSearchResponseAssemblerImpl
implements BaseSearchResponseAssembler {
    @Reference
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(BaseSearchResponse baseSearchResponse, SolrQuery solrQuery, QueryResponse queryResponse, BaseSearchRequest baseSearchRequest) {
        this.setExecutionTime(baseSearchResponse, queryResponse);
        this.setSearchRequestString(baseSearchResponse, solrQuery);
        this.setSearchResponseString(baseSearchResponse, queryResponse, baseSearchRequest);
        this.setStatsResponses(baseSearchResponse, queryResponse, baseSearchRequest);
    }

    protected Map<String, StatsResponse> getStatsResponseMap(QueryResponse queryResponse) {
        Map fieldStatsInfoMap = queryResponse.getFieldStatsInfo();
        if (MapUtil.isEmpty((Map)fieldStatsInfoMap)) {
            return null;
        }
        LinkedHashMap<String, StatsResponse> statsResponseMap = new LinkedHashMap<String, StatsResponse>();
        for (FieldStatsInfo fieldStatsInfo : fieldStatsInfoMap.values()) {
            StatsResponse statsResponse = this._statsTranslator.translateResponse(fieldStatsInfo);
            statsResponseMap.put(fieldStatsInfo.getName(), statsResponse);
        }
        return statsResponseMap;
    }

    protected void setExecutionTime(BaseSearchResponse baseSearchResponse, QueryResponse queryResponse) {
        baseSearchResponse.setExecutionTime(queryResponse.getElapsedTime());
    }

    protected void setSearchRequestString(BaseSearchResponse baseSearchResponse, SolrQuery solrQuery) {
        baseSearchResponse.setSearchRequestString(solrQuery.toString());
    }

    protected void setSearchResponseString(BaseSearchResponse baseSearchResponse, QueryResponse queryResponse, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.isIncludeResponseString()) {
            baseSearchResponse.setSearchResponseString(queryResponse.toString());
        }
    }

    protected void setStatsResponses(BaseSearchResponse baseSearchResponse, QueryResponse queryResponse, BaseSearchRequest baseSearchRequest) {
        Map<String, StatsResponse> statsResponseMap = this.getStatsResponseMap(queryResponse);
        if (statsResponseMap != null) {
            this.updateStatsResponses(baseSearchResponse, statsResponseMap, baseSearchRequest);
        }
    }

    protected void updateStatsResponses(BaseSearchResponse baseSearchResponse, Map<String, StatsResponse> statsResponseMap, BaseSearchRequest baseSearchRequest) {
        if (ListUtil.isNotEmpty((List)baseSearchRequest.getStatsRequests())) {
            for (Map.Entry<String, StatsResponse> entry : statsResponseMap.entrySet()) {
                baseSearchResponse.addStatsResponse(entry.getValue());
            }
        }
    }
}

