/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.document;

import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.solr8.internal.document.SolrDocumentFactory;
import com.liferay.portal.search.solr8.internal.document.SolrInputDocumentAtomicUpdateTranslator;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Solr"}, service={BulkableDocumentRequestTranslator.class})
public class SolrBulkableDocumentRequestTranslator
implements BulkableDocumentRequestTranslator {
    @Reference
    private SolrDocumentFactory _solrDocumentFactory;

    public SolrRequest translate(DeleteDocumentRequest deleteDocumentRequest) {
        String uid = deleteDocumentRequest.getUid();
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.deleteById(uid);
        if (deleteDocumentRequest.isRefresh()) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return updateRequest;
    }

    public QueryRequest translate(GetDocumentRequest getDocumentRequest) {
        ModifiableSolrParams modifiableSolrParams = new ModifiableSolrParams();
        modifiableSolrParams.set("qt", new String[]{"/get"});
        modifiableSolrParams.set("ids", new String[]{getDocumentRequest.getId()});
        return new QueryRequest((SolrParams)modifiableSolrParams);
    }

    public UpdateRequest translate(IndexDocumentRequest indexDocumentRequest) {
        UpdateRequest updateRequest = new UpdateRequest();
        if (indexDocumentRequest.getDocument() != null) {
            updateRequest.add(this._solrDocumentFactory.getSolrInputDocument(indexDocumentRequest.getDocument()));
        } else {
            updateRequest.add(this._solrDocumentFactory.getSolrInputDocument(indexDocumentRequest.getDocument71()));
        }
        if (indexDocumentRequest.isRefresh()) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return updateRequest;
    }

    public SolrRequest translate(UpdateDocumentRequest updateDocumentRequest) {
        UpdateRequest updateRequest = new UpdateRequest();
        if (updateDocumentRequest.getDocument() != null) {
            updateRequest.add(SolrInputDocumentAtomicUpdateTranslator.translate(this._solrDocumentFactory.getSolrInputDocument(updateDocumentRequest.getDocument())));
        } else {
            updateRequest.add(SolrInputDocumentAtomicUpdateTranslator.translate(this._solrDocumentFactory.getSolrInputDocument(updateDocumentRequest.getDocument71())));
        }
        if (updateDocumentRequest.isRefresh()) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return updateRequest;
    }
}

