/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.document;

import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.document.IndexDocumentRequestExecutor;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndexDocumentRequestExecutor.class})
public class IndexDocumentRequestExecutorImpl
implements IndexDocumentRequestExecutor {
    @Reference(target="(search.engine.impl=Solr)")
    private BulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;
    @Reference
    private SolrClientManager _solrClientManager;

    @Override
    public IndexDocumentResponse execute(IndexDocumentRequest indexDocumentRequest) {
        UpdateRequest request = (UpdateRequest)this._bulkableDocumentRequestTranslator.translate(indexDocumentRequest);
        try {
            UpdateResponse updateResponse = (UpdateResponse)request.process(this._solrClientManager.getSolrClient(), indexDocumentRequest.getIndexName());
            return new IndexDocumentResponse(updateResponse.getStatus(), indexDocumentRequest.getUid());
        }
        catch (Exception exception) {
            if (exception instanceof SolrException) {
                SolrException solrException = (SolrException)exception;
                throw solrException;
            }
            throw new RuntimeException(exception);
        }
    }
}

