/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentResponse;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.document.DocumentFieldsTranslator;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.document.GetDocumentRequestExecutor;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetDocumentRequestExecutor.class})
public class GetDocumentRequestExecutorImpl
implements GetDocumentRequestExecutor {
    private static final String _VERSION_FIELD = "_version_";
    @Reference(target="(search.engine.impl=Solr)")
    private BulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;
    @Reference
    private DocumentBuilderFactory _documentBuilderFactory;
    @Reference
    private SolrClientManager _solrClientManager;

    @Override
    public GetDocumentResponse execute(GetDocumentRequest getDocumentRequest) {
        QueryRequest queryRequest = (QueryRequest)this._bulkableDocumentRequestTranslator.translate(getDocumentRequest);
        try {
            QueryResponse queryResponse = (QueryResponse)queryRequest.process(this._solrClientManager.getSolrClient(), getDocumentRequest.getIndexName());
            SolrDocumentList solrDocumentList = queryResponse.getResults();
            if (solrDocumentList.isEmpty()) {
                return new GetDocumentResponse(false);
            }
            SolrDocument solrDocument = (SolrDocument)solrDocumentList.get(0);
            GetDocumentResponse getDocumentResponse = new GetDocumentResponse(true);
            getDocumentResponse.setSource(String.valueOf(solrDocument.getFieldValuesMap()));
            DocumentBuilder documentBuilder = this._documentBuilderFactory.builder();
            DocumentFieldsTranslator.translate(documentBuilder, solrDocument);
            getDocumentResponse.setDocument(documentBuilder.build());
            getDocumentResponse.setVersion(GetterUtil.getLong((Object)solrDocument.getFieldValue(_VERSION_FIELD)));
            return getDocumentResponse;
        }
        catch (Exception exception) {
            if (exception instanceof SolrException) {
                SolrException solrException = (SolrException)exception;
                throw solrException;
            }
            throw new RuntimeException(exception);
        }
    }
}

