/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.document;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentResponse;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.document.DeleteByQueryDocumentRequestExecutor;
import java.util.Map;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, service={DeleteByQueryDocumentRequestExecutor.class})
public class DeleteByQueryDocumentRequestExecutorImpl
implements DeleteByQueryDocumentRequestExecutor {
    private volatile String _defaultCollection;
    @Reference(target="(search.engine.impl=Solr)")
    private QueryTranslator<String> _queryTranslator;
    @Reference
    private SolrClientManager _solrClientManager;
    private volatile SolrConfiguration _solrConfiguration;

    @Override
    public DeleteByQueryDocumentResponse execute(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        UpdateRequest updateRequest = new UpdateRequest();
        String queryString = (String)this._queryTranslator.translate(deleteByQueryDocumentRequest.getQuery(), null);
        updateRequest.deleteByQuery(queryString);
        if (deleteByQueryDocumentRequest.isRefresh()) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        try {
            UpdateResponse updateResponse = (UpdateResponse)updateRequest.process(this._solrClientManager.getSolrClient(), this._defaultCollection);
            return new DeleteByQueryDocumentResponse((long)updateResponse.getStatus(), updateResponse.getElapsedTime());
        }
        catch (Exception exception) {
            if (exception instanceof SolrException) {
                SolrException solrException = (SolrException)exception;
                throw solrException;
            }
            throw new RuntimeException(exception);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
    }
}

