/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.search.engine.adapter.document;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentItemResponse;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentResponse;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.document.SolrDocumentFactory;
import com.liferay.portal.search.solr8.internal.document.SolrInputDocumentAtomicUpdateTranslator;
import com.liferay.portal.search.solr8.internal.search.engine.adapter.document.BulkDocumentRequestExecutor;
import com.liferay.portal.search.solr8.internal.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, service={BulkDocumentRequestExecutor.class})
public class BulkDocumentRequestExecutorImpl
implements BulkDocumentRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BulkDocumentRequestExecutorImpl.class);
    private volatile String _defaultCollection;
    @Reference
    private SolrClientManager _solrClientManager;
    private volatile SolrConfiguration _solrConfiguration;
    @Reference
    private SolrDocumentFactory _solrDocumentFactory;

    @Override
    public BulkDocumentResponse execute(BulkDocumentRequest bulkDocumentRequest) {
        BulkDocumentRequestClassifier bulkDocumentRequestClassifier = new BulkDocumentRequestClassifier(bulkDocumentRequest);
        ArrayList<BulkDocumentResponse> bulkDocumentResponses = new ArrayList<BulkDocumentResponse>();
        this.executeDeleteDocumentRequests(bulkDocumentRequest, bulkDocumentRequestClassifier, bulkDocumentResponses);
        this.executeIndexDocumentRequests(bulkDocumentRequest, bulkDocumentRequestClassifier, bulkDocumentResponses);
        this.executeUpdateDocumentRequests(bulkDocumentRequest, bulkDocumentRequestClassifier, bulkDocumentResponses);
        this.executeGetDocumentRequests(bulkDocumentRequestClassifier, bulkDocumentResponses);
        ArrayList bulkDocumentItemResponses = new ArrayList();
        boolean errors = false;
        long took = 0L;
        for (BulkDocumentResponse bulkDocumentResponse : bulkDocumentResponses) {
            if (bulkDocumentResponse.hasErrors()) {
                errors = true;
            }
            bulkDocumentItemResponses.addAll(bulkDocumentResponse.getBulkDocumentItemResponses());
            took += bulkDocumentResponse.getTook();
        }
        BulkDocumentResponse bulkDocumentResponse = new BulkDocumentResponse(took);
        bulkDocumentResponse.setErrors(errors);
        bulkDocumentItemResponses.forEach(bulkDocumentItemResponse -> bulkDocumentResponse.addBulkDocumentItemResponse(bulkDocumentItemResponse));
        return bulkDocumentResponse;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
    }

    protected SolrRequest buildDeleteSolrRequest(List<DeleteDocumentRequest> deleteDocumentRequests, boolean refresh) {
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.deleteById(TransformUtil.transform(deleteDocumentRequests, DeleteDocumentRequest::getUid));
        if (refresh) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return updateRequest;
    }

    protected SolrRequest buildGetSolrRequest(List<GetDocumentRequest> getDocumentRequests) {
        ModifiableSolrParams modifiableSolrParams = new ModifiableSolrParams();
        modifiableSolrParams.set("qt", new String[]{"/get"});
        modifiableSolrParams.set("ids", (String[])TransformUtil.transformToArray(getDocumentRequests, GetDocumentRequest::getId, String.class));
        return new QueryRequest((SolrParams)modifiableSolrParams);
    }

    protected SolrRequest buildIndexSolrRequest(List<IndexDocumentRequest> indexDocumentRequests, boolean refresh) {
        UpdateRequest updateRequest = new UpdateRequest();
        for (IndexDocumentRequest indexDocumentRequest : indexDocumentRequests) {
            if (indexDocumentRequest.getDocument() != null) {
                updateRequest.add(this._solrDocumentFactory.getSolrInputDocument(indexDocumentRequest.getDocument()));
                continue;
            }
            updateRequest.add(this._solrDocumentFactory.getSolrInputDocument(indexDocumentRequest.getDocument71()));
        }
        if (refresh) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return updateRequest;
    }

    protected SolrRequest buildUpdateSolrRequest(List<UpdateDocumentRequest> updateDocumentRequests, boolean refresh) {
        UpdateRequest updateRequest = new UpdateRequest();
        for (UpdateDocumentRequest updateDocumentRequest : updateDocumentRequests) {
            if (updateDocumentRequest.getDocument() != null) {
                updateRequest.add(SolrInputDocumentAtomicUpdateTranslator.translate(this._solrDocumentFactory.getSolrInputDocument(updateDocumentRequest.getDocument())));
                continue;
            }
            updateRequest.add(SolrInputDocumentAtomicUpdateTranslator.translate(this._solrDocumentFactory.getSolrInputDocument(updateDocumentRequest.getDocument71())));
        }
        if (refresh) {
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return updateRequest;
    }

    protected BulkDocumentResponse execute(SolrRequest solrRequest) {
        try {
            SolrResponse solrResponse = solrRequest.process(this._solrClientManager.getSolrClient(), this._defaultCollection);
            LogUtil.logSolrResponse(_log, solrResponse);
            BulkDocumentResponse bulkDocumentResponse = new BulkDocumentResponse(solrResponse.getElapsedTime());
            BulkDocumentItemResponse bulkDocumentItemResponse = new BulkDocumentItemResponse();
            if (solrResponse instanceof UpdateResponse) {
                UpdateResponse updateResponse = (UpdateResponse)solrResponse;
                bulkDocumentItemResponse.setStatus(updateResponse.getStatus());
            }
            if (solrResponse instanceof QueryResponse) {
                QueryResponse queryResponse = (QueryResponse)solrResponse;
                SolrDocumentList solrDocumentList = queryResponse.getResults();
                bulkDocumentItemResponse.setResult(solrDocumentList.toString());
                bulkDocumentItemResponse.setStatus(queryResponse.getStatus());
            }
            bulkDocumentResponse.addBulkDocumentItemResponse(bulkDocumentItemResponse);
            return bulkDocumentResponse;
        }
        catch (Exception exception) {
            if (exception instanceof SolrException) {
                SolrException solrException = (SolrException)exception;
                LogUtil.logSolrException(_log, solrException);
                BulkDocumentResponse bulkDocumentResponse = new BulkDocumentResponse(-1L);
                BulkDocumentItemResponse bulkDocumentItemResponse = new BulkDocumentItemResponse();
                bulkDocumentItemResponse.setCause((Exception)solrException);
                bulkDocumentItemResponse.setFailureMessage(solrException.getMessage());
                bulkDocumentItemResponse.setStatus(solrException.code());
                bulkDocumentResponse.addBulkDocumentItemResponse(bulkDocumentItemResponse);
                bulkDocumentResponse.setErrors(true);
                return bulkDocumentResponse;
            }
            throw new RuntimeException(exception);
        }
    }

    protected void executeDeleteDocumentRequests(BulkDocumentRequest bulkDocumentRequest, BulkDocumentRequestClassifier bulkDocumentRequestClassifier, List<BulkDocumentResponse> bulkDocumentResponses) {
        if (bulkDocumentRequestClassifier.hasDeleteDocumentRequests()) {
            BulkDocumentResponse bulkDocumentResponse = this.execute(this.buildDeleteSolrRequest(bulkDocumentRequestClassifier.getDeleteDocumentRequests(), bulkDocumentRequest.isRefresh()));
            bulkDocumentResponses.add(bulkDocumentResponse);
        }
    }

    protected void executeGetDocumentRequests(BulkDocumentRequestClassifier bulkDocumentRequestClassifier, List<BulkDocumentResponse> bulkDocumentResponses) {
        if (bulkDocumentRequestClassifier.hasGetDocumentRequests()) {
            BulkDocumentResponse bulkDocumentResponse = this.execute(this.buildGetSolrRequest(bulkDocumentRequestClassifier.getGetDocumentRequests()));
            bulkDocumentResponses.add(bulkDocumentResponse);
        }
    }

    protected void executeIndexDocumentRequests(BulkDocumentRequest bulkDocumentRequest, BulkDocumentRequestClassifier bulkDocumentRequestClassifier, List<BulkDocumentResponse> bulkDocumentResponses) {
        if (bulkDocumentRequestClassifier.hasIndexDocumentRequests()) {
            BulkDocumentResponse bulkDocumentResponse = this.execute(this.buildIndexSolrRequest(bulkDocumentRequestClassifier.getIndexDocumentRequests(), bulkDocumentRequest.isRefresh()));
            bulkDocumentResponses.add(bulkDocumentResponse);
        }
    }

    protected void executeUpdateDocumentRequests(BulkDocumentRequest bulkDocumentRequest, BulkDocumentRequestClassifier bulkDocumentRequestClassifier, List<BulkDocumentResponse> bulkDocumentResponses) {
        if (bulkDocumentRequestClassifier.hasUpdateDocumentRequests()) {
            BulkDocumentResponse bulkDocumentResponse = this.execute(this.buildUpdateSolrRequest(bulkDocumentRequestClassifier.getUpdateDocumentRequests(), bulkDocumentRequest.isRefresh()));
            bulkDocumentResponses.add(bulkDocumentResponse);
        }
    }

    private class BulkDocumentRequestClassifier {
        private List<DeleteDocumentRequest> _deleteDocumentRequests = new ArrayList<DeleteDocumentRequest>();
        private List<GetDocumentRequest> _getDocumentRequests = new ArrayList<GetDocumentRequest>();
        private List<IndexDocumentRequest> _indexDocumentRequests = new ArrayList<IndexDocumentRequest>();
        private List<UpdateDocumentRequest> _updateDocumentRequests = new ArrayList<UpdateDocumentRequest>();

        public BulkDocumentRequestClassifier(BulkDocumentRequest bulkDocumentRequest) {
            this._classify(bulkDocumentRequest);
        }

        public List<DeleteDocumentRequest> getDeleteDocumentRequests() {
            return this._deleteDocumentRequests;
        }

        public List<GetDocumentRequest> getGetDocumentRequests() {
            return this._getDocumentRequests;
        }

        public List<IndexDocumentRequest> getIndexDocumentRequests() {
            return this._indexDocumentRequests;
        }

        public List<UpdateDocumentRequest> getUpdateDocumentRequests() {
            return this._updateDocumentRequests;
        }

        public boolean hasDeleteDocumentRequests() {
            return !this._deleteDocumentRequests.isEmpty();
        }

        public boolean hasGetDocumentRequests() {
            return !this._getDocumentRequests.isEmpty();
        }

        public boolean hasIndexDocumentRequests() {
            return !this._indexDocumentRequests.isEmpty();
        }

        public boolean hasUpdateDocumentRequests() {
            return !this._updateDocumentRequests.isEmpty();
        }

        private void _classify(BulkDocumentRequest bulkDocumentRequest) {
            for (BulkableDocumentRequest bulkableDocumentRequest : bulkDocumentRequest.getBulkableDocumentRequests()) {
                bulkableDocumentRequest.accept(request -> {
                    if (request instanceof DeleteDocumentRequest) {
                        this._deleteDocumentRequests.add((DeleteDocumentRequest)request);
                    } else if (request instanceof GetDocumentRequest) {
                        this._getDocumentRequests.add((GetDocumentRequest)request);
                    } else if (request instanceof IndexDocumentRequest) {
                        this._indexDocumentRequests.add((IndexDocumentRequest)request);
                    } else if (request instanceof UpdateDocumentRequest) {
                        this._updateDocumentRequests.add((UpdateDocumentRequest)request);
                    }
                });
            }
        }
    }
}

