/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query.translator;

import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.solr8.internal.query.translator.SolrQueryTranslator;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;

public class BooleanQueryTranslatorImpl {
    public org.apache.lucene.search.Query translate(BooleanQuery booleanQuery, SolrQueryTranslator solrQueryTranslator) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        this.processQueryClause(booleanQuery.getMustQueryClauses(), solrQueryTranslator, query -> builder.add(query, BooleanClause.Occur.MUST));
        this.processQueryClause(booleanQuery.getMustNotQueryClauses(), solrQueryTranslator, query -> builder.add(query, BooleanClause.Occur.MUST_NOT));
        org.apache.lucene.search.BooleanQuery query2 = builder.build();
        if (booleanQuery.getBoost() != null) {
            return new BoostQuery((org.apache.lucene.search.Query)query2, booleanQuery.getBoost().floatValue());
        }
        return query2;
    }

    protected void processQueryClause(List<Query> queryClauses, SolrQueryTranslator solrQueryTranslator, LuceneQueryConsumer luceneQueryConsumer) {
        for (Query query : queryClauses) {
            luceneQueryConsumer.accept(this.translate(query, solrQueryTranslator));
        }
    }

    protected org.apache.lucene.search.Query translate(Query query, SolrQueryTranslator solrQueryTranslator) {
        return solrQueryTranslator.convert(query);
    }

    protected static interface LuceneQueryConsumer {
        public void accept(org.apache.lucene.search.Query var1);
    }
}

