/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query;

import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.internal.query.WildcardQueryTranslator;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.osgi.service.component.annotations.Component;

@Component(service={WildcardQueryTranslator.class})
public class WildcardQueryTranslatorImpl
implements WildcardQueryTranslator {
    @Override
    public Query translate(WildcardQuery wildcardQuery) {
        QueryTerm queryTerm = wildcardQuery.getQueryTerm();
        org.apache.lucene.search.WildcardQuery query = new org.apache.lucene.search.WildcardQuery(new Term(this._escapeSpaces(queryTerm.getField()), this._escape(queryTerm.getValue())));
        if (!wildcardQuery.isDefaultBoost()) {
            return new BoostQuery((Query)query, wildcardQuery.getBoost());
        }
        return query;
    }

    private String _escape(String value) {
        int x = 0;
        int length = value.length();
        StringBuilder sb = new StringBuilder(length * 2);
        for (int y = 0; y < length; ++y) {
            char c = value.charAt(y);
            if (c != '?' && c != ' ' && c != '*') continue;
            sb.append(QueryParser.escape((String)value.substring(x, y)));
            if (c == ' ') {
                sb.append('\\');
            }
            sb.append(c);
            x = y + 1;
        }
        sb.append(QueryParser.escape((String)value.substring(x)));
        return sb.toString();
    }

    private String _escapeSpaces(String value) {
        return StringUtil.replace((String)value, (char)' ', (String)"\\ ");
    }
}

