/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query;

import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.internal.query.TermQueryTranslator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.osgi.service.component.annotations.Component;

@Component(service={TermQueryTranslator.class})
public class TermQueryTranslatorImpl
implements TermQueryTranslator {
    @Override
    public Query translate(TermQuery termQuery) {
        QueryTerm queryTerm = termQuery.getQueryTerm();
        String value = queryTerm.getValue();
        if (value.isEmpty()) {
            value = "''";
        }
        org.apache.lucene.search.TermQuery query = new org.apache.lucene.search.TermQuery(new Term(this._escape(queryTerm.getField()), ClientUtils.escapeQueryChars((String)value)));
        if (!termQuery.isDefaultBoost()) {
            return new BoostQuery((Query)query, termQuery.getBoost());
        }
        return query;
    }

    private String _escape(String value) {
        return StringUtil.replace((String)value, (char)' ', (String)"\\ ");
    }
}

