/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query;

import com.liferay.portal.kernel.search.generic.MultiMatchQuery;
import com.liferay.portal.search.solr8.internal.query.MultiMatchQueryTranslator;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.osgi.service.component.annotations.Component;

@Component(service={MultiMatchQueryTranslator.class})
public class MultiMatchQueryTranslatorImpl
implements MultiMatchQueryTranslator {
    @Override
    public Query translate(MultiMatchQuery multiMatchQuery) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String field : multiMatchQuery.getFields()) {
            builder.add(this.translate(field, multiMatchQuery), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    protected Query translate(String field, MultiMatchQuery multiMatchQuery) {
        Query query = this.translate(field, multiMatchQuery.getType(), ClientUtils.escapeQueryChars((String)multiMatchQuery.getValue()), multiMatchQuery.getSlop());
        Map boostMap = multiMatchQuery.getFieldsBoosts();
        Float boost = (Float)boostMap.get(field);
        if (boost != null) {
            return new BoostQuery(query, boost.floatValue());
        }
        return query;
    }

    protected Query translate(String field, MultiMatchQuery.Type type, String value, Integer slop) {
        if (type == MultiMatchQuery.Type.PHRASE) {
            if (slop == null) {
                return new PhraseQuery(field, new String[]{value});
            }
            return new PhraseQuery(slop.intValue(), field, new String[]{value});
        }
        if (type == MultiMatchQuery.Type.PHRASE_PREFIX) {
            return new PrefixQuery(new Term(field, value));
        }
        return new TermQuery(new Term(field, value));
    }
}

