/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query;

import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.internal.query.MatchQueryTranslator;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.osgi.service.component.annotations.Component;

@Component(service={MatchQueryTranslator.class})
public class MatchQueryTranslatorImpl
implements MatchQueryTranslator {
    @Override
    public Query translate(MatchQuery matchQuery) {
        Query query = this.translateMatchQuery(matchQuery);
        if (!matchQuery.isDefaultBoost()) {
            return new BoostQuery(query, matchQuery.getBoost());
        }
        return query;
    }

    protected Query translateMatchQuery(MatchQuery matchQuery) {
        String field = matchQuery.getField();
        MatchQuery.Type matchQueryType = matchQuery.getType();
        String value = matchQuery.getValue();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            matchQueryType = MatchQuery.Type.PHRASE;
            if ((value = StringUtil.unquote((String)value)).endsWith("*")) {
                matchQueryType = MatchQuery.Type.PHRASE_PREFIX;
            }
        }
        value = this._trimStars(value);
        value = QueryParser.escape((String)value);
        value = this._defuseUpperCaseLuceneBooleanOperators(value);
        if (matchQueryType == null) {
            matchQueryType = MatchQuery.Type.BOOLEAN;
        }
        if (matchQueryType == MatchQuery.Type.BOOLEAN) {
            return this.translateQueryTypeBoolean(field, value);
        }
        if (matchQueryType == MatchQuery.Type.PHRASE) {
            return this.translateQueryTypePhrase(field, value, matchQuery.getSlop());
        }
        if (matchQueryType == MatchQuery.Type.PHRASE_PREFIX) {
            return this.translateQueryTypePhrasePrefix(field, value);
        }
        throw new IllegalArgumentException("Invalid match query type: " + matchQueryType);
    }

    protected Query translateQueryTypeBoolean(String field, String value) {
        value = this._encloseMultiword(value, "(", ")");
        return new TermQuery(new Term(field, value));
    }

    protected Query translateQueryTypePhrase(String field, String value, Integer slop) {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.add(new Term(field, value));
        if (slop != null) {
            builder.setSlop(slop.intValue());
        }
        return builder.build();
    }

    protected Query translateQueryTypePhrasePrefix(String field, String value) {
        value = value.concat("*");
        value = this._encloseMultiword(value, "(+", ")");
        return new TermQuery(new Term(field, value));
    }

    private String _defuseUpperCaseLuceneBooleanOperators(String value) {
        value = StringUtil.replace((String)value, (String)"AND", (String)"and");
        value = StringUtil.replace((String)value, (String)"OR", (String)"or");
        value = StringUtil.replace((String)value, (String)"NOT", (String)"not");
        return value;
    }

    private String _encloseMultiword(String value, String open, String close) {
        if (value.indexOf(32) == -1) {
            return value;
        }
        return open + value + close;
    }

    private String _trimStars(String value) {
        if (value.equals("*")) {
            return value;
        }
        if (value.startsWith("*")) {
            value = value.substring(1);
        }
        if (value.endsWith("*")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

