/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.solr8.internal.query.FuzzyQueryTranslator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.osgi.service.component.annotations.Component;

@Component(service={FuzzyQueryTranslator.class})
public class FuzzyQueryTranslatorImpl
implements FuzzyQueryTranslator {
    @Override
    public Query translate(com.liferay.portal.kernel.search.generic.FuzzyQuery fuzzyQuery) {
        Term term = new Term(fuzzyQuery.getField(), fuzzyQuery.getValue());
        int maxEdits = GetterUtil.getInteger((Object)fuzzyQuery.getMaxEdits());
        int prefixLength = GetterUtil.getInteger((Object)fuzzyQuery.getPrefixLength());
        int maxExpansions = GetterUtil.getInteger((Object)fuzzyQuery.getMaxExpansions(), (int)50);
        if (!fuzzyQuery.isDefaultBoost()) {
            fuzzyQuery.setBoost(fuzzyQuery.getBoost());
        }
        return new FuzzyQuery(term, maxEdits, prefixLength, maxExpansions, false);
    }
}

