/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.query;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.search.solr8.internal.query.BooleanQueryTranslator;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.osgi.service.component.annotations.Component;

@Component(service={BooleanQueryTranslator.class})
public class BooleanQueryTranslatorImpl
implements BooleanQueryTranslator {
    @Override
    public Query translate(BooleanQuery booleanQuery, QueryVisitor<Query> queryVisitor) {
        List clauses = booleanQuery.clauses();
        if (clauses.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (BooleanClause booleanClause : clauses) {
            Query query = this.translate((com.liferay.portal.kernel.search.Query)booleanClause.getClause(), queryVisitor);
            if (query == null) continue;
            builder.add(query, this.translate(booleanClause.getBooleanClauseOccur()));
        }
        org.apache.lucene.search.BooleanQuery query = builder.build();
        if (!booleanQuery.isDefaultBoost()) {
            return new BoostQuery((Query)query, booleanQuery.getBoost());
        }
        return query;
    }

    protected BooleanClause.Occur translate(BooleanClauseOccur booleanClauseOccur) {
        if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
            return BooleanClause.Occur.MUST;
        }
        if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
            return BooleanClause.Occur.MUST_NOT;
        }
        if (booleanClauseOccur.equals(BooleanClauseOccur.SHOULD)) {
            return BooleanClause.Occur.SHOULD;
        }
        throw new IllegalArgumentException();
    }

    protected Query translate(com.liferay.portal.kernel.search.Query query, QueryVisitor<Query> queryVisitor) {
        return (Query)query.accept(queryVisitor);
    }
}

