/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.interceptor;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.osgi.service.component.annotations.Component;

@Component(service={HttpRequestInterceptor.class})
public class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        HttpHost targetHttpHost;
        AuthScope authScope;
        AuthState authState = (AuthState)httpContext.getAttribute("http.auth.target-scope");
        if (authState.getAuthScheme() != null) {
            return;
        }
        CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
        Credentials credentials = credentialsProvider.getCredentials(authScope = new AuthScope((targetHttpHost = (HttpHost)httpContext.getAttribute("http.target_host")).getHostName(), targetHttpHost.getPort()));
        if (credentials != null) {
            authState.update((AuthScheme)new BasicScheme(), credentials);
        }
    }
}

