/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.http;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.solr8.configuration.SolrSSLSocketFactoryConfiguration;
import com.liferay.portal.search.solr8.internal.http.KeyStoreLoader;
import com.liferay.portal.search.solr8.internal.http.SSLSocketFactoryBuilder;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrSSLSocketFactoryConfiguration"}, service={SSLSocketFactoryBuilder.class})
public class SSLSocketFactoryBuilderImpl
implements SSLSocketFactoryBuilder {
    private static final Log _log = LogFactoryUtil.getLog(SSLSocketFactoryBuilderImpl.class);
    @Reference
    private KeyStoreLoader _keyStoreLoader;
    private volatile char[] _keyStorePassword;
    private volatile String _keyStorePath;
    private volatile String _keyStoreType = KeyStore.getDefaultType();
    private volatile SolrSSLSocketFactoryConfiguration _solrSSLSocketFactoryConfiguration;
    private volatile char[] _trustStorePassword;
    private volatile String _trustStorePath;
    private volatile String _trustStoreType = KeyStore.getDefaultType();
    private volatile boolean _verifyServerCertificate = true;
    private volatile boolean _verifyServerHostname = true;

    @Override
    public SSLConnectionSocketFactory build() throws Exception {
        KeyStore keyStore = this._keyStoreLoader.load(this._keyStoreType, this._keyStorePath, this._keyStorePassword);
        if (keyStore == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Use system defaults because there is no custom key store");
            }
            return SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        TrustSelfSignedStrategy trustStrategy = null;
        if (this._verifyServerCertificate) {
            KeyStore trustKeyStore = this._keyStoreLoader.load(this._trustStoreType, this._trustStorePath, this._trustStorePassword);
            if (trustKeyStore == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Use system defaults because there is no custom trust store");
                }
                return SSLConnectionSocketFactory.getSystemSocketFactory();
            }
        } else {
            trustStrategy = new TrustSelfSignedStrategy();
        }
        HostnameVerifier hostnameVerifier = null;
        if (this._verifyServerHostname) {
            hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        sslContextBuilder.loadKeyMaterial(keyStore, this._keyStorePassword);
        sslContextBuilder.loadTrustMaterial((TrustStrategy)trustStrategy);
        SSLContext sslContext = sslContextBuilder.build();
        try {
            return new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Use system defaults because the custom SSL socket factory was not able to initialize", (Throwable)exception);
            }
            return SSLConnectionSocketFactory.getSystemSocketFactory();
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrSSLSocketFactoryConfiguration = (SolrSSLSocketFactoryConfiguration)ConfigurableUtil.createConfigurable(SolrSSLSocketFactoryConfiguration.class, properties);
        String keyStorePassword = this._solrSSLSocketFactoryConfiguration.keyStorePassword();
        this._keyStorePassword = keyStorePassword.toCharArray();
        this._keyStorePath = this._solrSSLSocketFactoryConfiguration.keyStorePath();
        this._keyStoreType = this._solrSSLSocketFactoryConfiguration.keyStoreType();
        String trustStorePassword = this._solrSSLSocketFactoryConfiguration.trustStorePassword();
        this._trustStorePassword = trustStorePassword.toCharArray();
        this._trustStorePath = this._solrSSLSocketFactoryConfiguration.trustStorePath();
        this._trustStoreType = this._solrSSLSocketFactoryConfiguration.trustStoreType();
        this._verifyServerCertificate = this._solrSSLSocketFactoryConfiguration.verifyServerCertificate();
        this._verifyServerHostname = this._solrSSLSocketFactoryConfiguration.verifyServerName();
    }
}

