/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.http;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.search.solr8.internal.http.KeyStoreLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import org.osgi.service.component.annotations.Component;

@Component(service={KeyStoreLoader.class})
public class KeyStoreLoaderImpl
implements KeyStoreLoader {
    private static final Log _log = LogFactoryUtil.getLog(KeyStoreLoaderImpl.class);

    @Override
    public KeyStore load(String keyStoreType, String keyStoreLocation, char[] keyStorePassword) throws Exception {
        if (keyStoreLocation == null) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (InputStream inputStream = this.loadFile(keyStoreLocation);){
            keyStore.load(inputStream, keyStorePassword);
            if (_log.isDebugEnabled()) {
                this.dumpKeyStore(keyStore);
            }
        }
        return keyStore;
    }

    protected void dumpKeyStore(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            boolean certificateEntry = keyStore.isCertificateEntry(alias);
            StringBundler sb = null;
            sb = certificateEntry ? new StringBundler(8) : new StringBundler(6);
            sb.append("alias=");
            sb.append(alias);
            if (certificateEntry) {
                sb.append(",certificate=");
                sb.append(String.valueOf(keyStore.getCertificate(alias)));
            }
            sb.append(",certificateEntry=");
            sb.append(certificateEntry);
            sb.append(",keyEntry=");
            sb.append(keyStore.isKeyEntry(alias));
            log.debug((Object)sb.toString());
        }
    }

    protected InputStream loadFile(String fileName) throws FileNotFoundException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading file " + fileName));
        }
        InputStream inputStream = null;
        if (fileName.startsWith("classpath:")) {
            fileName = fileName.substring(10);
            Class<KeyStoreLoaderImpl> clazz = KeyStoreLoaderImpl.class;
            inputStream = clazz.getResourceAsStream(fileName);
        }
        if (inputStream != null) {
            return inputStream;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Attempting to load from the file system because " + fileName + " is not in the class path"));
        }
        return new FileInputStream(fileName);
    }
}

