/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.http;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.solr8.configuration.SolrHttpClientFactoryConfiguration;
import com.liferay.portal.search.solr8.internal.http.BasePoolingHttpClientFactory;
import com.liferay.portal.search.solr8.internal.http.HttpClientFactory;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrHttpClientFactoryConfiguration"}, property={"type=BASIC"}, service={HttpClientFactory.class})
public class BasicAuthPoolingHttpClientFactory
extends BasePoolingHttpClientFactory {
    private AuthScope _authScope;
    private String _password;
    private volatile SolrHttpClientFactoryConfiguration _solrHttpClientFactoryConfiguration;
    private String _userName;

    public void setAuthScope(AuthScope authScope) {
        this._authScope = authScope;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrHttpClientFactoryConfiguration = (SolrHttpClientFactoryConfiguration)ConfigurableUtil.createConfigurable(SolrHttpClientFactoryConfiguration.class, properties);
        this.setDefaultMaxConnectionsPerRoute(this._solrHttpClientFactoryConfiguration.defaultMaxConnectionsPerRoute());
        this.setMaxTotalConnections(this._solrHttpClientFactoryConfiguration.maxTotalConnections());
        String basicAuthPassword = this._solrHttpClientFactoryConfiguration.basicAuthPassword();
        this.setPassword(basicAuthPassword);
        String basicAuthUserName = this._solrHttpClientFactoryConfiguration.basicAuthUserName();
        this.setUserName(basicAuthUserName);
    }

    @Override
    protected void configure(HttpClientBuilder httpClientBuilder) {
        if (Validator.isBlank((String)this._userName)) {
            return;
        }
        if (this._authScope == null) {
            this._authScope = AuthScope.ANY;
        }
        if (Validator.isNull((String)this._password)) {
            this._password = "";
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(this._authScope, (Credentials)new UsernamePasswordCredentials(this._userName, this._password));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    @Override
    protected PoolingHttpClientConnectionManager createPoolingHttpClientConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    @Deactivate
    protected void deactivate() {
        this.shutdown();
    }
}

