/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.http;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.solr8.internal.http.HttpClientFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.osgi.service.component.annotations.Reference;

public abstract class BasePoolingHttpClientFactory
implements HttpClientFactory {
    @Reference
    protected HttpRequestInterceptor httpRequestInterceptor;
    private static final Log _log = LogFactoryUtil.getLog(BasePoolingHttpClientFactory.class);
    private Integer _defaultMaxConnectionsPerRoute;
    private Integer _maxTotalConnections;
    private PoolingHttpClientConnectionManager _poolingClientConnectionManager;

    @Override
    public HttpClient createInstance() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Create instance");
        }
        this._poolingClientConnectionManager = this.createPoolingHttpClientConnectionManager();
        this.applyProperties(this._poolingClientConnectionManager);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this._poolingClientConnectionManager);
        this.applyProperties(httpClientBuilder);
        this.configure(httpClientBuilder);
        return httpClientBuilder.build();
    }

    public void setDefaultMaxConnectionsPerRoute(Integer defaultMaxConnectionsPerRoute) {
        this._defaultMaxConnectionsPerRoute = defaultMaxConnectionsPerRoute;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this._maxTotalConnections = maxTotalConnections;
    }

    @Override
    public void shutdown() {
        PoolStats poolStats;
        int availableConnections;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Shut down");
        }
        if (this._poolingClientConnectionManager == null) {
            return;
        }
        for (int retry = 0; retry < 10 && (availableConnections = (poolStats = this._poolingClientConnectionManager.getTotalStats()).getAvailable()) > 0; ++retry) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{this.toString(), " is waiting on ", availableConnections, " connections"}));
            }
            this._poolingClientConnectionManager.closeIdleConnections(200L, TimeUnit.MILLISECONDS);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)interruptedException);
            }
        }
        this._poolingClientConnectionManager.shutdown();
        this._poolingClientConnectionManager = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(this.toString() + " was shut down"));
        }
    }

    protected void applyProperties(HttpClientBuilder httpClientBuilder) {
        httpClientBuilder.addInterceptorFirst(this.httpRequestInterceptor);
    }

    protected void applyProperties(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        if (this._defaultMaxConnectionsPerRoute != null) {
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(this._defaultMaxConnectionsPerRoute.intValue());
        }
        if (this._maxTotalConnections != null) {
            poolingHttpClientConnectionManager.setMaxTotal(this._maxTotalConnections.intValue());
        }
    }

    protected abstract void configure(HttpClientBuilder var1);

    protected abstract PoolingHttpClientConnectionManager createPoolingHttpClientConnectionManager() throws Exception;
}

