/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.groupby;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.solr8.internal.groupby.GroupByTranslator;
import java.util.HashSet;
import java.util.Locale;
import org.apache.solr.client.solrj.SolrQuery;
import org.osgi.service.component.annotations.Component;

@Component(service={GroupByTranslator.class})
public class DefaultGroupByTranslator
implements GroupByTranslator {
    private static final String _SOLR_SCORE_FIELD = "score";

    @Override
    public void translate(SolrQuery solrQuery, GroupByRequest groupByRequest, Locale locale, String[] highlightFieldNames, boolean highlightEnabled, boolean highlightRequireFieldMatch, int highlightFragmentSize, int highlightSnippetSize) {
        this.configureGroups(solrQuery, groupByRequest);
        if (highlightEnabled) {
            this.addHighlights(solrQuery, highlightFragmentSize, highlightRequireFieldMatch, highlightSnippetSize, highlightFieldNames, locale);
        }
    }

    protected void addDocsSort(SolrQuery solrQuery, String sortFieldName, SolrQuery.ORDER order) {
        solrQuery.set("group.sort", new String[]{sortFieldName + " " + order});
    }

    protected void addDocsSorts(SolrQuery solrQuery, Sort[] sorts) {
        this.addSorts(solrQuery, sorts, true);
    }

    protected void addHighlightedField(SolrQuery solrQuery, Locale locale, String fieldName) {
        solrQuery.addHighlightField(fieldName);
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        solrQuery.addHighlightField(localizedFieldName);
    }

    protected void addHighlights(SolrQuery solrQuery, int highlightFragmentSize, boolean highlightRequireFieldMatch, int highlightSnippetSize, String[] highlightFieldNames, Locale locale) {
        solrQuery.setHighlight(true);
        solrQuery.setHighlightFragsize(highlightFragmentSize);
        solrQuery.setHighlightRequireFieldMatch(highlightRequireFieldMatch);
        solrQuery.setHighlightSimplePost("</liferay-hl>");
        solrQuery.setHighlightSimplePre("<liferay-hl>");
        solrQuery.setHighlightSnippets(highlightSnippetSize);
        for (String highlightFieldName : highlightFieldNames) {
            this.addHighlightedField(solrQuery, locale, highlightFieldName);
        }
    }

    protected void addSorts(SolrQuery solrQuery, Sort[] sorts, boolean sortDocs) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>();
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = Field.getSortFieldName((Sort)sort, (String)_SOLR_SCORE_FIELD))) continue;
            sortFieldNames.add(sortFieldName);
            SolrQuery.ORDER order = SolrQuery.ORDER.asc;
            if (sort.isReverse() || sortFieldName.equals(_SOLR_SCORE_FIELD)) {
                order = SolrQuery.ORDER.desc;
            }
            if (sortDocs) {
                this.addDocsSort(solrQuery, sortFieldName, order);
                continue;
            }
            this.addTermsSort(solrQuery, sortFieldName, order);
        }
    }

    protected void addTermsSort(SolrQuery solrQuery, String sortFieldName, SolrQuery.ORDER order) {
        solrQuery.addSort(new SolrQuery.SortClause(sortFieldName, order));
    }

    protected void addTermsSorts(SolrQuery solrQuery, Sort[] sorts) {
        this.addSorts(solrQuery, sorts, false);
    }

    protected void configureGroups(SolrQuery solrQuery, GroupByRequest groupByRequest) {
        int docsSize;
        int termsSize;
        solrQuery.set("group", true);
        solrQuery.set("group.field", new String[]{groupByRequest.getField()});
        solrQuery.set("group.format", new String[]{"grouped"});
        solrQuery.set("group.ngroups", true);
        int termsStart = GetterUtil.getInteger((Object)groupByRequest.getTermsStart());
        if (termsStart > 0) {
            solrQuery.set("start", termsStart);
        }
        if ((termsSize = GetterUtil.getInteger((Object)groupByRequest.getTermsSize())) > 0) {
            solrQuery.set("rows", termsSize);
        }
        this.addTermsSorts(solrQuery, groupByRequest.getTermsSorts());
        int docsStart = GetterUtil.getInteger((Object)groupByRequest.getDocsStart());
        if (docsStart > 0) {
            solrQuery.set("group.offset", docsStart);
        }
        if ((docsSize = GetterUtil.getInteger((Object)groupByRequest.getDocsSize())) > 0) {
            solrQuery.set("group.limit", docsSize);
        }
        this.addDocsSorts(solrQuery, groupByRequest.getDocsSorts());
    }
}

