/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.filter;

import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.internal.filter.TermsFilterTranslator;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.osgi.service.component.annotations.Component;

@Component(service={TermsFilterTranslator.class})
public class TermsFilterTranslatorImpl
implements TermsFilterTranslator {
    @Override
    public Query translate(TermsFilter termsFilter) {
        String field = this._escape(termsFilter.getField());
        ArrayList<BytesRef> bytesRefs = new ArrayList<BytesRef>();
        for (String value : termsFilter.getValues()) {
            if (value.isEmpty()) {
                value = "''";
            }
            Term term = new Term(field, ClientUtils.escapeQueryChars((String)value));
            bytesRefs.add(term.bytes());
        }
        TermInSetQuery query = new TermInSetQuery(field, bytesRefs);
        if (bytesRefs.size() == 1) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)query, BooleanClause.Occur.SHOULD);
        return builder.build();
    }

    private String _escape(String value) {
        return StringUtil.replace((String)value, (char)' ', (String)"\\ ");
    }
}

