/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.filter;

import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.internal.filter.TermFilterTranslator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.osgi.service.component.annotations.Component;

@Component(service={TermFilterTranslator.class})
public class TermFilterTranslatorImpl
implements TermFilterTranslator {
    @Override
    public Query translate(TermFilter termFilter) {
        String value = termFilter.getValue();
        if (value.isEmpty()) {
            value = "''";
        }
        Term term = new Term(this._escape(termFilter.getField()), ClientUtils.escapeQueryChars((String)value));
        return new TermQuery(term);
    }

    private String _escape(String value) {
        return StringUtil.replace((String)value, (char)' ', (String)"\\ ");
    }
}

