/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.filter;

import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.DateRangeTermFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;
import com.liferay.portal.kernel.search.filter.GeoBoundingBoxFilter;
import com.liferay.portal.kernel.search.filter.GeoDistanceFilter;
import com.liferay.portal.kernel.search.filter.GeoDistanceRangeFilter;
import com.liferay.portal.kernel.search.filter.GeoPolygonFilter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.PrefixFilter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.RangeTermFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.search.filter.DateRangeFilter;
import com.liferay.portal.search.filter.TermsSetFilter;
import com.liferay.portal.search.solr8.internal.filter.BooleanFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.DateRangeFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.DateRangeTermFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.ExistsFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.FilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.GeoBoundingBoxFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.GeoDistanceFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.GeoDistanceRangeFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.GeoPolygonFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.MissingFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.PrefixFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.QueryFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.RangeTermFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.TermFilterTranslator;
import com.liferay.portal.search.solr8.internal.filter.TermsFilterTranslator;
import org.apache.lucene.search.Query;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Solr"}, service={FilterTranslator.class})
public class SolrFilterTranslator
implements FilterTranslator<String>,
com.liferay.portal.search.filter.FilterVisitor<Query> {
    @Reference
    private BooleanFilterTranslator _booleanFilterTranslator;
    @Reference
    private DateRangeFilterTranslator _dateRangeFilterTranslator;
    @Reference
    private DateRangeTermFilterTranslator _dateRangeTermFilterTranslator;
    @Reference
    private ExistsFilterTranslator _existsFilterTranslator;
    @Reference
    private GeoBoundingBoxFilterTranslator _geoBoundingBoxFilterTranslator;
    @Reference
    private GeoDistanceFilterTranslator _geoDistanceFilterTranslator;
    @Reference
    private GeoDistanceRangeFilterTranslator _geoDistanceRangeFilterTranslator;
    @Reference
    private GeoPolygonFilterTranslator _geoPolygonFilterTranslator;
    @Reference
    private MissingFilterTranslator _missingFilterTranslator;
    @Reference
    private PrefixFilterTranslator _prefixFilterTranslator;
    @Reference
    private QueryFilterTranslator _queryFilterTranslator;
    @Reference
    private RangeTermFilterTranslator _rangeTermFilterTranslator;
    @Reference
    private TermFilterTranslator _termFilterTranslator;
    @Reference
    private TermsFilterTranslator _termsFilterTranslator;

    @Override
    public String translate(Filter filter) {
        Query luceneQuery;
        String filterString = "";
        if (filter != null && (luceneQuery = (Query)filter.accept((FilterVisitor)this)) != null) {
            filterString = luceneQuery.toString();
        }
        return filterString;
    }

    public Query visit(BooleanFilter booleanFilter) {
        return this._booleanFilterTranslator.translate(booleanFilter, (FilterVisitor<Query>)this);
    }

    public Query visit(DateRangeFilter dateRangeFilter) {
        return this._dateRangeFilterTranslator.translate(dateRangeFilter);
    }

    public Query visit(DateRangeTermFilter dateRangeTermFilter) {
        return this._dateRangeTermFilterTranslator.translate(dateRangeTermFilter);
    }

    public Query visit(ExistsFilter existsFilter) {
        return this._existsFilterTranslator.translate(existsFilter);
    }

    public Query visit(GeoBoundingBoxFilter geoBoundingBoxFilter) {
        return this._geoBoundingBoxFilterTranslator.translate(geoBoundingBoxFilter);
    }

    public Query visit(GeoDistanceFilter geoDistanceFilter) {
        return this._geoDistanceFilterTranslator.translate(geoDistanceFilter);
    }

    public Query visit(GeoDistanceRangeFilter geoDistanceRangeFilter) {
        return this._geoDistanceRangeFilterTranslator.translate(geoDistanceRangeFilter);
    }

    public Query visit(GeoPolygonFilter geoPolygonFilter) {
        return this._geoPolygonFilterTranslator.translate(geoPolygonFilter);
    }

    public Query visit(MissingFilter missingFilter) {
        return this._missingFilterTranslator.translate(missingFilter);
    }

    public Query visit(PrefixFilter prefixFilter) {
        return this._prefixFilterTranslator.translate(prefixFilter);
    }

    public Query visit(QueryFilter queryFilter) {
        return this._queryFilterTranslator.translate(queryFilter);
    }

    public Query visit(RangeTermFilter rangeTermFilter) {
        return this._rangeTermFilterTranslator.translate(rangeTermFilter);
    }

    public Query visit(TermFilter termFilter) {
        return this._termFilterTranslator.translate(termFilter);
    }

    public Query visit(TermsFilter termsFilter) {
        return this._termsFilterTranslator.translate(termsFilter);
    }

    public Query visit(TermsSetFilter termsSetFilter) {
        throw new UnsupportedOperationException();
    }
}

