/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.filter;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;
import com.liferay.portal.search.solr8.internal.filter.BooleanFilterTranslator;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.osgi.service.component.annotations.Component;

@Component(service={BooleanFilterTranslator.class})
public class BooleanFilterTranslatorImpl
implements BooleanFilterTranslator {
    @Override
    public Query translate(BooleanFilter booleanFilter, FilterVisitor<Query> filterVisitor) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (BooleanClause booleanClause : booleanFilter.getMustBooleanClauses()) {
            builder.add(this.translate((BooleanClause<Filter>)booleanClause, filterVisitor), BooleanClause.Occur.MUST);
        }
        for (BooleanClause booleanClause : booleanFilter.getMustNotBooleanClauses()) {
            builder.add(this.translate((BooleanClause<Filter>)booleanClause, filterVisitor), BooleanClause.Occur.MUST_NOT);
        }
        if (this._isOnlyMustNotClauses(booleanFilter)) {
            builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        }
        for (BooleanClause booleanClause : booleanFilter.getShouldBooleanClauses()) {
            builder.add(this.translate((BooleanClause<Filter>)booleanClause, filterVisitor), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    protected Query translate(BooleanClause<Filter> booleanClause, FilterVisitor<Query> filterVisitor) {
        Filter filter = (Filter)booleanClause.getClause();
        return (Query)filter.accept(filterVisitor);
    }

    private boolean _isOnlyMustNotClauses(BooleanFilter booleanFilter) {
        List booleanClauses = booleanFilter.getMustBooleanClauses();
        if (!booleanClauses.isEmpty()) {
            return false;
        }
        booleanClauses = booleanFilter.getShouldBooleanClauses();
        if (!booleanClauses.isEmpty()) {
            return false;
        }
        booleanClauses = booleanFilter.getMustNotBooleanClauses();
        return !booleanClauses.isEmpty();
    }
}

