/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.facet;

import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.DefaultTermCollector;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.solr8.internal.facet.FacetUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class SolrFacetQueryCollector
implements FacetCollector {
    private final Map<String, Integer> _counts;
    private final String _fieldName;
    private List<TermCollector> _termCollectors;

    public SolrFacetQueryCollector(Facet facet, NamedList<?> namedList) {
        String name = FacetUtil.getAggregationName(facet);
        this._counts = this._getCountsInSameOrder(namedList.asMap(0), name);
        this._fieldName = name;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public TermCollector getTermCollector(String term) {
        return new DefaultTermCollector(term, GetterUtil.getInteger((Object)this._counts.get(term)));
    }

    public List<TermCollector> getTermCollectors() {
        if (this._termCollectors != null) {
            return this._termCollectors;
        }
        ArrayList<TermCollector> termCollectors = new ArrayList<TermCollector>();
        for (Map.Entry<String, Integer> entry : this._counts.entrySet()) {
            Integer count = entry.getValue();
            DefaultTermCollector termCollector = new DefaultTermCollector(entry.getKey(), count.intValue());
            termCollectors.add((TermCollector)termCollector);
        }
        this._termCollectors = termCollectors;
        return this._termCollectors;
    }

    private Map<String, Integer> _getCountsInSameOrder(Map<String, NamedList<?>> map1, String name) {
        LinkedHashMap<String, Integer> map2 = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, NamedList<?>> entry : map1.entrySet()) {
            String bucket = entry.getKey();
            if (!bucket.startsWith(name)) continue;
            NamedList<?> namedList = entry.getValue();
            map2.put(bucket.substring(name.length() + 1), GetterUtil.getInteger((Object)namedList.get("count")));
        }
        return map2;
    }
}

