/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.facet;

import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.DefaultTermCollector;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.solr8.internal.facet.FacetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class SolrFacetFieldCollector
implements FacetCollector {
    private final Map<String, Integer> _counts;
    private final String _fieldName;
    private List<TermCollector> _termCollectors;

    public SolrFacetFieldCollector(Facet facet, NamedList<?> namedList) {
        String name = FacetUtil.getAggregationName(facet);
        List<NamedList<?>> list = this._getBuckets((NamedList)namedList.get(name));
        this._counts = this._getCountsInSameOrder(list);
        this._fieldName = name;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public TermCollector getTermCollector(String term) {
        return new DefaultTermCollector(term, GetterUtil.getInteger((Object)this._counts.get(term)));
    }

    public List<TermCollector> getTermCollectors() {
        if (this._termCollectors != null) {
            return this._termCollectors;
        }
        ArrayList<TermCollector> termCollectors = new ArrayList<TermCollector>();
        for (Map.Entry<String, Integer> entry : this._counts.entrySet()) {
            termCollectors.add((TermCollector)new DefaultTermCollector(entry.getKey(), entry.getValue().intValue()));
        }
        this._termCollectors = termCollectors;
        return this._termCollectors;
    }

    private List<NamedList<?>> _getBuckets(NamedList<?> namedList) {
        if (namedList == null) {
            return null;
        }
        return (List)namedList.get("buckets");
    }

    private Map<String, Integer> _getCountsInSameOrder(List<NamedList<?>> list) {
        if (ListUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (NamedList<?> namedList : list) {
            map.put(GetterUtil.getString((String)String.valueOf(namedList.get("val"))), GetterUtil.getInteger((Object)namedList.get("count")));
        }
        return map;
    }
}

