/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.solr8.internal.facet.FacetProcessor;
import com.liferay.portal.search.solr8.internal.facet.FacetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"class.name=com.liferay.portal.kernel.search.facet.RangeFacet", "class.name=com.liferay.portal.search.internal.facet.ModifiedFacetImpl"}, service={FacetProcessor.class})
public class RangeFacetProcessor
implements FacetProcessor<SolrQuery> {
    @Reference
    protected JSONFactory jsonFactory;

    @Override
    public Map<String, JSONObject> processFacet(Facet facet) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        this.addConfigurationRanges(map, facet);
        this.addCustomRange(map, facet);
        return RangeFacetProcessor.sort(map);
    }

    protected static Map<String, JSONObject> sort(Map<String, JSONObject> map1) {
        ArrayList<String> keys = new ArrayList<String>(map1.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, JSONObject> map2 = new LinkedHashMap<String, JSONObject>();
        keys.forEach(key -> {
            JSONObject cfr_ignored_0 = (JSONObject)map2.put((String)key, (JSONObject)map1.get(key));
        });
        return map2;
    }

    protected void addConfigurationRanges(Map<String, JSONObject> map, Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject jsonObject = facetConfiguration.getData();
        JSONArray jsonArray = jsonObject.getJSONArray("ranges");
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject rangeJSONObject = jsonArray.getJSONObject(i);
            String range = rangeJSONObject.getString("range");
            this.putFacetParameters(map, facet, range);
        }
    }

    protected void addCustomRange(Map<String, JSONObject> map, Facet facet) {
        SearchContext searchContext = facet.getSearchContext();
        String range = GetterUtil.getString((Object)searchContext.getAttribute(facet.getFieldId()));
        if (Validator.isNull((String)range)) {
            return;
        }
        this.putFacetParameters(map, facet, range);
    }

    protected JSONObject getFacetParametersJSONObject(Facet facet, String range) {
        JSONObject jsonObject = this.jsonFactory.createJSONObject();
        jsonObject.put("q", facet.getFieldName() + ":" + range).put("type", "query");
        return jsonObject;
    }

    protected void putFacetParameters(Map<String, JSONObject> map, Facet facet, String range) {
        String name = FacetUtil.getAggregationName(facet) + "_" + range;
        JSONObject jsonObject = this.getFacetParametersJSONObject(facet, range);
        map.put(name, jsonObject);
    }
}

