/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.engine;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.engine.ConnectionInformation;
import com.liferay.portal.search.engine.ConnectionInformationBuilder;
import com.liferay.portal.search.engine.ConnectionInformationBuilderFactory;
import com.liferay.portal.search.engine.NodeInformation;
import com.liferay.portal.search.engine.NodeInformationBuilder;
import com.liferay.portal.search.engine.NodeInformationBuilderFactory;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.util.NamedList;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, service={SearchEngineInformation.class})
public class SolrSearchEngineInformation
implements SearchEngineInformation {
    @Reference
    protected ConnectionInformationBuilderFactory connectionInformationBuilderFactory;
    @Reference
    protected NodeInformationBuilderFactory nodeInformationBuilderFactory;
    @Reference
    protected SolrClientManager solrClientManager;
    private static final Log _log = LogFactoryUtil.getLog(SolrSearchEngineInformation.class);
    private volatile String _defaultCollection;
    private volatile SolrConfiguration _solrConfiguration;

    public String getClientVersionString() {
        return Version.LATEST.toString();
    }

    public List<ConnectionInformation> getConnectionInformationList() {
        ArrayList<ConnectionInformation> connectionInformationList = new ArrayList<ConnectionInformation>();
        ConnectionInformationBuilder connectionInformationBuilder = this.connectionInformationBuilderFactory.getConnectionInformationBuilder();
        connectionInformationBuilder.connectionId(this._defaultCollection);
        try {
            ArrayList<NodeInformation> nodeInformationList = new ArrayList<NodeInformation>();
            NodeInformationBuilder nodeInformationBuilder = this.nodeInformationBuilderFactory.getNodeInformationBuilder();
            nodeInformationBuilder.name(this._defaultCollection);
            nodeInformationBuilder.version(this.getVersion());
            nodeInformationList.add(nodeInformationBuilder.build());
            connectionInformationBuilder.nodeInformationList(nodeInformationList);
        }
        catch (Exception exception) {
            connectionInformationBuilder.error(exception.toString());
            _log.error((Object)"Unable to get node information", (Throwable)exception);
        }
        connectionInformationList.add(connectionInformationBuilder.build());
        return connectionInformationList;
    }

    public String getNodesString() {
        try {
            StringBundler sb = new StringBundler(5);
            sb.append(this._defaultCollection);
            sb.append(" ");
            sb.append("(");
            sb.append(this.getVersion());
            sb.append(")");
            return sb.toString();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get node information", (Throwable)exception);
            StringBundler sb = new StringBundler(3);
            sb.append("(Error: ");
            sb.append(exception.toString());
            sb.append(")");
            return sb.toString();
        }
    }

    public String getVendorString() {
        return "Solr";
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
    }

    protected String getVersion() throws Exception {
        SolrClient solrClient = this.solrClientManager.getSolrClient();
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, "/admin/info/system", null);
        SimpleSolrResponse response = (SimpleSolrResponse)request.process(solrClient);
        NamedList namedList = response.getResponse();
        NamedList luceneNamedList = (NamedList)namedList.get("lucene");
        return (String)luceneNamedList.get("solr-spec-version");
    }
}

