/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.document;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.solr8.internal.document.SolrDocumentFactory;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.osgi.service.component.annotations.Component;

@Component(service={SolrDocumentFactory.class})
public class DefaultSolrDocumentFactory
implements SolrDocumentFactory {
    @Override
    public SolrInputDocument getSolrInputDocument(Document document) {
        SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
        Map fields = document.getFields();
        for (Field field : fields.values()) {
            String name = field.getName();
            if (!field.isLocalized()) {
                Object[] values = field.getValues();
                if (ArrayUtil.isEmpty((Object[])values)) continue;
                for (Object value : values) {
                    if (value == null) continue;
                    value = ((String)value).trim();
                    this.addField(solrInputDocument, field, (String)value, name);
                }
                continue;
            }
            Map localizedValues = field.getLocalizedValues();
            for (Map.Entry entry : localizedValues.entrySet()) {
                String defaultLanguageId;
                String value = (String)entry.getValue();
                if (Validator.isNull((String)value)) continue;
                value = value.trim();
                Locale locale = (Locale)entry.getKey();
                String languageId = LocaleUtil.toLanguageId((Locale)locale);
                if (languageId.equals(defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()))) {
                    solrInputDocument.addField(name, (Object)value);
                }
                this.addField(solrInputDocument, field, value, Field.getLocalizedName((Locale)locale, (String)name));
            }
        }
        return solrInputDocument;
    }

    @Override
    public SolrInputDocument getSolrInputDocument(com.liferay.portal.search.document.Document document) {
        SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
        Map fields = document.getFields();
        for (com.liferay.portal.search.document.Field field : fields.values()) {
            this.addField(field, solrInputDocument);
        }
        return solrInputDocument;
    }

    protected void addField(com.liferay.portal.search.document.Field field, SolrInputDocument solrInputDocument) {
        for (Object value : field.getValues()) {
            solrInputDocument.addField(field.getName(), this.toSolrValue(value));
        }
    }

    protected void addField(SolrInputDocument solrInputDocument, Field field, String value, String localizedName) {
        GeoLocationPoint geoLocationPoint = field.getGeoLocationPoint();
        if (geoLocationPoint != null) {
            value = geoLocationPoint.getLatitude() + "," + geoLocationPoint.getLongitude();
        }
        solrInputDocument.addField(localizedName, (Object)value);
        if (field.isSortable()) {
            solrInputDocument.addField(Field.getSortableFieldName((String)localizedName), (Object)value);
        }
    }

    protected Object toSolrValue(Object value) {
        GeoLocationPoint geoLocationPoint;
        if (value instanceof GeoLocationPoint && (geoLocationPoint = (GeoLocationPoint)value) != null) {
            value = geoLocationPoint.getLatitude() + "," + geoLocationPoint.getLongitude();
        }
        return value;
    }
}

