/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.connection;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.SolrClientFactory;
import com.liferay.portal.search.solr8.internal.http.HttpClientFactory;
import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, service={SolrClientManager.class})
public class SolrClientManager {
    private static final Log _log = LogFactoryUtil.getLog(SolrClientManager.class);
    @Reference(target="(type=BASIC)")
    private HttpClientFactory _basicAuthPoolingHttpClientFactory;
    @Reference(target="(type=CERT)")
    private HttpClientFactory _certAuthPoolingHttpClientFactory;
    @Reference(target="(type=CLOUD)")
    private SolrClientFactory _cloudSolrClientFactory;
    @Reference(target="(type=REPLICATED)")
    private SolrClientFactory _replicatedSolrClientFactory;
    private SolrClient _solrClient;
    private SolrConfiguration _solrConfiguration;

    public SolrClient getSolrClient() {
        return this._solrClient;
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        String clientType = this._solrConfiguration.clientType();
        SolrClientFactory solrClientFactory = null;
        if (clientType.equals("CLOUD")) {
            solrClientFactory = this._cloudSolrClientFactory;
        }
        if (clientType.equals("REPLICATED")) {
            solrClientFactory = this._replicatedSolrClientFactory;
        }
        if (solrClientFactory == null) {
            throw new IllegalStateException("Solr client factory not initialized: " + clientType);
        }
        String authMode = this._solrConfiguration.authenticationMode();
        HttpClientFactory httpClientFactory = null;
        if (authMode.equals("BASIC")) {
            httpClientFactory = this._basicAuthPoolingHttpClientFactory;
        }
        if (authMode.equals("CERT")) {
            httpClientFactory = this._certAuthPoolingHttpClientFactory;
        }
        if (httpClientFactory == null) {
            throw new IllegalStateException("No HTTP client factory for " + authMode);
        }
        this._solrClient = solrClientFactory.getSolrClient(this._solrConfiguration, httpClientFactory);
    }

    @Deactivate
    protected void deactivate() {
        block2: {
            try {
                this._solrClient.close();
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)ioException);
            }
        }
    }
}

