/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.connection;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.ReadWriteSolrClient;
import com.liferay.portal.search.solr8.internal.connection.SolrClientFactory;
import com.liferay.portal.search.solr8.internal.http.HttpClientFactory;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, property={"type=REPLICATED"}, service={SolrClientFactory.class})
public class ReplicatedSolrClientFactory
implements SolrClientFactory {
    private static final Log _log = LogFactoryUtil.getLog(ReplicatedSolrClientFactory.class);
    private volatile String _defaultCollectionPath;
    private volatile SolrConfiguration _solrConfiguration;

    @Override
    public SolrClient getSolrClient(SolrConfiguration solrConfiguration, HttpClientFactory httpClientFactory) throws Exception {
        Object[] readURLs = this._removeCollectionPath(solrConfiguration.readURL());
        Object[] writeURLs = this._removeCollectionPath(solrConfiguration.writeURL());
        if (ArrayUtil.isEmpty((Object[])writeURLs)) {
            throw new IllegalArgumentException("Must configure at least one write URL");
        }
        if (ArrayUtil.isEmpty((Object[])readURLs)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"No read URLs configured, using write URLs for read");
            }
            readURLs = writeURLs;
        }
        LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
        builder.withBaseSolrUrls((String[])readURLs);
        builder.withHttpClient(httpClientFactory.createInstance());
        LBHttpSolrClient readerLBHttpSolrClient = builder.build();
        builder.withBaseSolrUrls((String[])writeURLs);
        builder.withHttpClient(httpClientFactory.createInstance());
        LBHttpSolrClient writerLBHttpSolrClient = builder.build();
        return new ReadWriteSolrClient((SolrClient)readerLBHttpSolrClient, (SolrClient)writerLBHttpSolrClient);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollectionPath = "/" + this._solrConfiguration.defaultCollection();
    }

    private String[] _removeCollectionPath(String[] urls) {
        String[] newUrls = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            newUrls[i] = url.endsWith(this._defaultCollectionPath) ? StringUtil.removeSubstring((String)url, (String)this._defaultCollectionPath) : url;
        }
        return newUrls;
    }
}

