/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal.connection;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.SolrClientFactory;
import com.liferay.portal.search.solr8.internal.http.HttpClientFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.osgi.service.component.annotations.Component;

@Component(property={"type=CLOUD"}, service={SolrClientFactory.class})
public class CloudSolrClientFactory
implements SolrClientFactory {
    @Override
    public SolrClient getSolrClient(SolrConfiguration solrConfiguration, HttpClientFactory httpClientFactory) throws Exception {
        String defaultCollection = solrConfiguration.defaultCollection();
        if (Validator.isNull((String)defaultCollection)) {
            throw new IllegalStateException("Default collection is null");
        }
        String zkHost = solrConfiguration.zkHost();
        if (Validator.isNull((String)zkHost)) {
            throw new IllegalStateException("Zookeeper host is null");
        }
        CloudSolrClient.Builder builder = new CloudSolrClient.Builder();
        builder.withHttpClient(httpClientFactory.createInstance());
        builder.withZkHost(zkHost);
        CloudSolrClient cloudSolrClient = builder.build();
        cloudSolrClient.setDefaultCollection(defaultCollection);
        return cloudSolrClient;
    }
}

