/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentResponse;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.suggest.BaseGenericSpellCheckIndexWriter;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, property={"search.engine.impl=Solr"}, service={SpellCheckIndexWriter.class})
public class SolrSpellCheckIndexWriter
extends BaseGenericSpellCheckIndexWriter {
    private static final Log _log = LogFactoryUtil.getLog(SolrSpellCheckIndexWriter.class);
    private volatile String _defaultCollection;
    private volatile boolean _logExceptionsOnly;
    @Reference(target="(search.engine.impl=Solr)")
    private SearchEngineAdapter _searchEngineAdapter;
    private volatile SolrConfiguration _solrConfiguration;

    public void clearQuerySuggestionDictionaryIndexes(SearchContext searchContext) throws SearchException {
        String deleteQuery = this.buildDeleteQuery(searchContext, "querySuggestion");
        this.deleteByQuery(searchContext, deleteQuery);
    }

    public void clearSpellCheckerDictionaryIndexes(SearchContext searchContext) throws SearchException {
        String deleteQuery = this.buildDeleteQuery(searchContext, "spellChecker");
        this.deleteByQuery(searchContext, deleteQuery);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.setDocumentPrototype((Document)new DocumentImpl());
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
        this._logExceptionsOnly = this._solrConfiguration.logExceptionsOnly();
    }

    protected void addDocument(String documentType, SearchContext searchContext, Document document) throws SearchException {
        try {
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this._defaultCollection, document);
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                indexDocumentRequest.setRefresh(true);
            }
            this._searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
        }
        catch (RuntimeException runtimeException) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    protected void addDocuments(String documentType, SearchContext searchContext, Collection<Document> documents) throws SearchException {
        block5: {
            try {
                BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
                if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                    bulkDocumentRequest.setRefresh(true);
                }
                documents.forEach(document -> {
                    IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this._defaultCollection, document);
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
                });
                BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
                if (!bulkDocumentResponse.hasErrors()) break block5;
                if (this._logExceptionsOnly) {
                    _log.error((Object)"Bulk add failed");
                    break block5;
                }
                throw new SystemException("Bulk add failed");
            }
            catch (RuntimeException runtimeException) {
                if (this._logExceptionsOnly) {
                    _log.error((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    protected void addQuerySeparator(StringBundler sb) {
        sb.append(" ");
        sb.append("+");
    }

    protected void addQueryType(StringBundler sb, String type) {
        sb.append("type");
        sb.append(":");
        sb.append(type);
    }

    protected String buildDeleteQuery(SearchContext searchContext, String type) {
        StringBundler sb = new StringBundler(14);
        sb.append("+");
        sb.append("companyId");
        sb.append(":");
        sb.append(searchContext.getCompanyId());
        this.addQuerySeparator(sb);
        this.addQueryType(sb, type);
        return sb.toString();
    }

    protected void deleteByQuery(SearchContext searchContext, String deleteQuery) throws SearchException {
        try {
            DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)new StringQuery(deleteQuery), new String[]{this._defaultCollection});
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                deleteByQueryDocumentRequest.setRefresh(true);
            }
            this._searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
        }
        catch (RuntimeException runtimeException) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }
}

