/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal;

import com.liferay.osgi.util.service.Snapshot;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.search.suggest.Suggester;
import com.liferay.portal.kernel.search.suggest.SuggesterResults;
import com.liferay.portal.kernel.search.suggest.WeightedWord;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.connection.SolrClientManager;
import com.liferay.portal.search.solr8.internal.suggest.NGramQueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, property={"distance.threshold=0.6f", "search.engine.impl=Solr"}, service={QuerySuggester.class})
public class SolrQuerySuggester
implements QuerySuggester {
    private static final long _GLOBAL_GROUP_ID = 0L;
    private static final float _INFINITE_WEIGHT = 100.0f;
    private static final int _MAX_QUERY_RESULTS = 500;
    private static final Log _log = LogFactoryUtil.getLog(SolrQuerySuggester.class);
    private static final Snapshot<StringDistance> _stringDistanceSnapshot = new Snapshot(SolrQuerySuggester.class, StringDistance.class, null, true);
    private volatile String _defaultCollection;
    private final StringDistance _defaultStringDistance = new LevenshteinDistance();
    private volatile double _distanceThreshold;
    @Reference
    private Localization _localization;
    @Reference
    private NGramQueryBuilder _nGramQueryBuilder;
    @Reference
    private SolrClientManager _solrClientManager;
    private volatile SolrConfiguration _solrConfiguration;

    public String spellCheckKeywords(SearchContext searchContext) throws SearchException {
        List<Suggestion> suggestions = this.doSuggest(searchContext, 1);
        ArrayList<String> words = new ArrayList<String>();
        for (Suggestion suggestion : suggestions) {
            words.add(this.getWord(suggestion.term, suggestion.options));
        }
        return StringUtil.merge(words, (String)" ");
    }

    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) throws SearchException {
        List<Suggestion> suggestions = this.doSuggest(searchContext, max);
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (Suggestion suggestion : suggestions) {
            map.put(suggestion.term, suggestion.options);
        }
        return map;
    }

    public SuggesterResults suggest(SearchContext searchContext, Suggester suggester) {
        return new SuggesterResults();
    }

    public String[] suggestKeywordQueries(SearchContext searchContext, int max) throws SearchException {
        String keywords = searchContext.getKeywords();
        if (Validator.isBlank((String)keywords)) {
            return new String[0];
        }
        SolrClient solrClient = this._solrClientManager.getSolrClient();
        try {
            SolrQuery solrQuery = this._nGramQueryBuilder.getNGramQuery(keywords);
            solrQuery.setFilterQueries(this.getFilterQueries(searchContext, "querySuggestion"));
            solrQuery.setRows(Integer.valueOf(max));
            QueryResponse queryResponse = solrClient.query(this._defaultCollection, (SolrParams)solrQuery);
            SolrDocumentList solrDocumentList = queryResponse.getResults();
            String[] querySuggestions = new String[solrDocumentList.size()];
            for (int i = 0; i < solrDocumentList.size(); ++i) {
                SolrDocument solrDocument = (SolrDocument)solrDocumentList.get(i);
                querySuggestions[i] = (String)solrDocument.getFieldValue("keywordSearch");
            }
            return querySuggestions;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to execute Solr query", (Throwable)exception);
            }
            return new String[0];
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._distanceThreshold = MapUtil.getDouble(properties, (String)"distance.threshold", (double)0.6);
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
    }

    protected List<Suggestion> doSuggest(final SearchContext searchContext, final int max) throws SearchException {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        List<String> keywords = Arrays.asList(StringUtils.split((String)StringUtil.toLowerCase((String)StringUtil.unquote((String)searchContext.getKeywords()))));
        for (final String keyword : keywords) {
            suggestions.add(new Suggestion(){
                {
                    this.options = SolrQuerySuggester.this.suggestKeywords(searchContext, max, keyword);
                    this.term = keyword;
                }
            });
        }
        return suggestions;
    }

    protected String[] getFilterQueries(SearchContext searchContext, String type) {
        ArrayList<String> filterQueries = new ArrayList<String>(4);
        String companyIdFilterQuery = this.getFilterQuery("companyId", searchContext.getCompanyId());
        filterQueries.add(companyIdFilterQuery);
        long[] groupIds = this.getGroupIdsForSuggestions(searchContext);
        if (groupIds != null) {
            String groupIdFilterQuery = this.getFilterQuery("groupId", groupIds);
            filterQueries.add(groupIdFilterQuery);
        }
        String localeFilterQuery = this.getFilterQuery("languageId", searchContext.getLanguageId());
        filterQueries.add(localeFilterQuery);
        String suggestionFilterQuery = this.getFilterQuery("type", type);
        filterQueries.add(suggestionFilterQuery);
        return filterQueries.toArray(new String[0]);
    }

    protected String getFilterQuery(String field, long value) {
        return this.getFilterQuery(field, String.valueOf(value));
    }

    protected String getFilterQuery(String field, long[] values) {
        if (ArrayUtil.isEmpty((long[])values)) {
            return "";
        }
        StringBundler sb = new StringBundler(6 * values.length - 2);
        for (int i = 0; i < values.length; ++i) {
            sb.append(field);
            sb.append(":");
            sb.append(values[i]);
            sb.append(" ");
            if (i >= values.length - 1) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }

    protected String getFilterQuery(String field, String value) {
        return StringBundler.concat((String[])new String[]{field, ":", value});
    }

    protected long[] getGroupIdsForSuggestions(SearchContext searchContext) {
        long[] groupIds = searchContext.getGroupIds();
        if (!ArrayUtil.isEmpty((long[])groupIds)) {
            groupIds = ArrayUtil.remove((long[])groupIds, (long)-1L);
        }
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return new long[]{0L};
        }
        if (ArrayUtil.contains((long[])groupIds, (long)0L)) {
            return groupIds;
        }
        return ArrayUtil.append((long[])groupIds, (long)0L);
    }

    protected String getWord(String term, List<String> options) {
        if (ListUtil.isEmpty(options)) {
            return term;
        }
        return options.get(0);
    }

    protected void setLocalization(Localization localization) {
        this._localization = localization;
    }

    protected List<String> suggestKeywords(SearchContext searchContext, int max, String input) throws SearchException {
        TreeSet<WeightedWord> suggestionsSet = this.suggestKeywords(searchContext, input);
        max = Math.min(max, suggestionsSet.size());
        ArrayList<String> suggestionsList = new ArrayList<String>(max);
        int count = 0;
        Iterator<WeightedWord> iterator = suggestionsSet.descendingIterator();
        while (iterator.hasNext()) {
            WeightedWord weightedWord = iterator.next();
            if (weightedWord.getWeight() != 0.0f) {
                suggestionsList.add(weightedWord.getWord());
            } else {
                suggestionsList.add(input);
            }
            if (++count < max) continue;
            break;
        }
        return suggestionsList;
    }

    protected TreeSet<WeightedWord> suggestKeywords(SearchContext searchContext, String input) throws SearchException {
        SolrClient solrClient = this._solrClientManager.getSolrClient();
        try {
            HashMap<String, WeightedWord> weightedWordsMap = new HashMap<String, WeightedWord>();
            TreeSet<WeightedWord> weightedWordsSet = new TreeSet<WeightedWord>();
            SolrQuery solrQuery = this._nGramQueryBuilder.getNGramQuery(input);
            solrQuery.addFilterQuery(this.getFilterQueries(searchContext, "spellChecker"));
            solrQuery.setRows(Integer.valueOf(500));
            QueryResponse queryResponse = solrClient.query(this._defaultCollection, (SolrParams)solrQuery, SolrRequest.METHOD.POST);
            SolrDocumentList solrDocumentList = queryResponse.getResults();
            StringDistance stringDistance = (StringDistance)_stringDistanceSnapshot.get();
            if (stringDistance == null) {
                stringDistance = this._defaultStringDistance;
            }
            for (SolrDocument solrDocument : solrDocumentList) {
                List suggestions = (List)solrDocument.get((Object)"spellCheckWord");
                if (ListUtil.isEmpty((List)suggestions)) continue;
                String suggestion = (String)suggestions.get(0);
                float weight = GetterUtil.getFloat((Object)solrDocument.get((Object)"priority"));
                if (suggestion.equals(input)) {
                    weight = 100.0f;
                } else {
                    String suggestionLowerCase;
                    String inputLowerCase = StringUtil.toLowerCase((String)input);
                    float distance = stringDistance.getDistance(inputLowerCase, suggestionLowerCase = StringUtil.toLowerCase((String)suggestion));
                    if ((double)distance >= this._distanceThreshold) {
                        weight += distance;
                    }
                }
                WeightedWord weightedWord = (WeightedWord)weightedWordsMap.get(suggestion);
                if (weightedWord == null) {
                    weightedWord = new WeightedWord(suggestion, weight);
                    weightedWordsMap.put(suggestion, weightedWord);
                    weightedWordsSet.add(weightedWord);
                    continue;
                }
                if (!(weight > weightedWord.getWeight())) continue;
                weightedWord.setWeight(weight);
            }
            return weightedWordsSet;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to execute Solr query", (Throwable)exception);
            }
            throw new SearchException(exception.getMessage(), (Throwable)exception);
        }
    }

    private static class Suggestion {
        protected List<String> options;
        protected String term;

        private Suggestion() {
        }
    }
}

