/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexWriter;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentResponse;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexRequest;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, property={"search.engine.impl=Solr"}, service={IndexWriter.class})
public class SolrIndexWriter
extends BaseIndexWriter {
    private static final Log _log = LogFactoryUtil.getLog(SolrIndexWriter.class);
    private volatile String _defaultCollection;
    private volatile boolean _logExceptionsOnly;
    @Reference(target="(search.engine.impl=Solr)")
    private SearchEngineAdapter _searchEngineAdapter;
    private volatile SolrConfiguration _solrConfiguration;
    @Reference(target="(search.engine.impl=Solr)")
    private SpellCheckIndexWriter _spellCheckIndexWriter;

    public void addDocument(SearchContext searchContext, Document document) {
        try {
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this._defaultCollection, document);
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                indexDocumentRequest.setRefresh(true);
            }
            this._searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
        }
        catch (RuntimeException runtimeException) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public void addDocuments(SearchContext searchContext, Collection<Document> documents) {
        block5: {
            try {
                BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
                if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                    bulkDocumentRequest.setRefresh(true);
                }
                documents.forEach(document -> {
                    IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this._defaultCollection, document);
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
                });
                BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
                if (!bulkDocumentResponse.hasErrors()) break block5;
                if (this._logExceptionsOnly) {
                    _log.error((Object)"Bulk add failed");
                    break block5;
                }
                throw new SystemException("Bulk add failed");
            }
            catch (RuntimeException runtimeException) {
                if (this._logExceptionsOnly) {
                    _log.error((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    public void commit(SearchContext searchContext) {
        RefreshIndexRequest refreshIndexRequest = new RefreshIndexRequest(new String[]{this._defaultCollection});
        try {
            this._searchEngineAdapter.execute((IndexRequest)refreshIndexRequest);
        }
        catch (RuntimeException runtimeException) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public void deleteDocument(SearchContext searchContext, String uid) {
        DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(this._defaultCollection, uid);
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            deleteDocumentRequest.setRefresh(true);
        }
        try {
            this._searchEngineAdapter.execute((DocumentRequest)deleteDocumentRequest);
        }
        catch (RuntimeException runtimeException) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public void deleteDocuments(SearchContext searchContext, Collection<String> uids) {
        block5: {
            try {
                BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
                if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                    bulkDocumentRequest.setRefresh(true);
                }
                uids.forEach(uid -> {
                    DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(this._defaultCollection, uid);
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
                });
                BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
                if (!bulkDocumentResponse.hasErrors()) break block5;
                if (this._logExceptionsOnly) {
                    _log.error((Object)"Bulk delete failed");
                    break block5;
                }
                throw new SystemException("Bulk delete failed");
            }
            catch (RuntimeException runtimeException) {
                if (this._logExceptionsOnly) {
                    _log.error((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    public void deleteEntityDocuments(SearchContext searchContext, String className) {
        try {
            BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
            long companyId = searchContext.getCompanyId();
            if (companyId > 0L) {
                booleanQuery.add((Query)new TermQueryImpl("companyId", String.valueOf(companyId)), BooleanClauseOccur.MUST);
            }
            booleanQuery.add((Query)new TermQueryImpl("entryClassName", className), BooleanClauseOccur.MUST);
            DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)booleanQuery, new String[]{this._defaultCollection});
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                deleteByQueryDocumentRequest.setRefresh(true);
            }
            this._searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
        }
        catch (Exception exception) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new SystemException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void partiallyUpdateDocument(SearchContext searchContext, Document document) {
        try {
            UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(this._defaultCollection, document.getUID(), document);
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                updateDocumentRequest.setRefresh(true);
            }
            this._searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
        }
        catch (RuntimeException runtimeException) {
            if (this._logExceptionsOnly) {
                _log.error((Throwable)runtimeException);
            }
            throw runtimeException;
        }
    }

    public void partiallyUpdateDocuments(SearchContext searchContext, Collection<Document> documents) {
        block5: {
            try {
                BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
                if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                    bulkDocumentRequest.setRefresh(true);
                }
                documents.forEach(document -> {
                    UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(this._defaultCollection, document.getUID(), document);
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)updateDocumentRequest);
                });
                BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
                if (!bulkDocumentResponse.hasErrors()) break block5;
                if (this._logExceptionsOnly) {
                    _log.error((Object)"Bulk partial update failed");
                    break block5;
                }
                throw new SystemException("Bulk partial update failed");
            }
            catch (RuntimeException runtimeException) {
                if (this._logExceptionsOnly) {
                    _log.error((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    public void updateDocument(SearchContext searchContext, Document document) {
        this.updateDocuments(searchContext, Collections.singleton(document));
    }

    public void updateDocuments(SearchContext searchContext, Collection<Document> documents) {
        block5: {
            try {
                BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
                if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                    bulkDocumentRequest.setRefresh(true);
                }
                documents.forEach(document -> {
                    DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(this._defaultCollection, document.getUID());
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
                    IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this._defaultCollection, document);
                    bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
                });
                BulkDocumentResponse bulkDocumentResponse = (BulkDocumentResponse)this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
                if (!bulkDocumentResponse.hasErrors()) break block5;
                if (this._logExceptionsOnly) {
                    _log.error((Object)"Update failed");
                    break block5;
                }
                throw new SystemException("Update failed");
            }
            catch (RuntimeException runtimeException) {
                if (this._logExceptionsOnly) {
                    _log.error((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
        this._logExceptionsOnly = this._solrConfiguration.logExceptionsOnly();
    }

    protected SpellCheckIndexWriter getSpellCheckIndexWriter() {
        return this._spellCheckIndexWriter;
    }
}

