/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.solr8.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.legacy.searcher.SearchResponseBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchResponseBuilder;
import com.liferay.portal.search.solr8.configuration.SolrConfiguration;
import com.liferay.portal.search.solr8.internal.search.response.HitsImpl;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.solr8.configuration.SolrConfiguration"}, property={"search.engine.impl=Solr"}, service={IndexSearcher.class})
public class SolrIndexSearcher
extends BaseIndexSearcher {
    private static final Log _log = LogFactoryUtil.getLog(SolrIndexSearcher.class);
    private volatile String _defaultCollection;
    private volatile boolean _logExceptionsOnly;
    @Reference
    private Props _props;
    @Reference(target="(search.engine.impl=Solr)")
    private QuerySuggester _querySuggester;
    @Reference(target="(search.engine.impl=Solr)")
    private SearchEngineAdapter _searchEngineAdapter;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SearchResponseBuilderFactory _searchResponseBuilderFactory;
    private volatile SolrConfiguration _solrConfiguration;

    public String getQueryString(SearchContext searchContext, Query query) {
        return this._searchEngineAdapter.getQueryString(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hits search(SearchContext searchContext, Query query) {
        Hits hits;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            int start = searchContext.getStart();
            if (start == -1) {
                start = 0;
            } else if (start < 0) {
                throw new IllegalArgumentException("Invalid start " + start);
            }
            int end = searchContext.getEnd();
            if (end == -1) {
                end = GetterUtil.getInteger((String)this._props.get("index.search.limit"));
            } else if (end < 0) {
                throw new IllegalArgumentException("Invalid end " + end);
            }
            SearchResponseBuilder searchResponseBuilder = this._getSearchResponseBuilder(searchContext);
            Hits hits2 = null;
            while (true) {
                SearchSearchRequest searchSearchRequest = this.createSearchSearchRequest(searchContext, query, start, end);
                SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((com.liferay.portal.search.engine.adapter.search.SearchRequest)searchSearchRequest);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime(), " ms"}));
                }
                this.populateResponse(searchSearchResponse, searchResponseBuilder);
                searchResponseBuilder.searchHits(searchSearchResponse.getSearchHits());
                hits2 = searchSearchResponse.getHits();
                Document[] documents = hits2.getDocs();
                if (documents.length != 0 || start == 0) break;
                int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)hits2.getLength());
                start = startAndEnd[0];
                end = startAndEnd[1];
            }
            hits2.setStart(stopWatch.getStartTime());
            hits = hits2;
        }
        catch (Exception exception) {
            HitsImpl hitsImpl;
            try {
                if (!this._logExceptionsOnly) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new SystemException(exception.getMessage(), (Throwable)exception);
                }
                _log.error((Throwable)exception);
                hitsImpl = new HitsImpl();
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
            }
            return hitsImpl;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long searchCount(SearchContext searchContext, Query query) {
        long l;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            CountSearchRequest countSearchRequest = this.createCountSearchRequest(searchContext, query);
            CountSearchResponse countSearchResponse = (CountSearchResponse)this._searchEngineAdapter.execute((com.liferay.portal.search.engine.adapter.search.SearchRequest)countSearchRequest);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", countSearchResponse.getSearchRequestString(), " in ", countSearchResponse.getExecutionTime(), " ms"}));
            }
            this.populateResponse((BaseSearchResponse)countSearchResponse, this._getSearchResponseBuilder(searchContext));
            l = countSearchResponse.getCount();
        }
        catch (Exception exception) {
            long l2;
            try {
                if (!this._logExceptionsOnly) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new SystemException(exception.getMessage(), (Throwable)exception);
                }
                _log.error((Throwable)exception);
                l2 = 0L;
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
            }
            return l2;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching took ", stopWatch.getTime(), " ms"}));
        }
        return l;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._solrConfiguration = (SolrConfiguration)ConfigurableUtil.createConfigurable(SolrConfiguration.class, properties);
        this._defaultCollection = this._solrConfiguration.defaultCollection();
        this._logExceptionsOnly = this._solrConfiguration.logExceptionsOnly();
    }

    protected CountSearchRequest createCountSearchRequest(SearchContext searchContext, Query query) {
        CountSearchRequest countSearchRequest = new CountSearchRequest();
        this.populateBaseSearchRequest((BaseSearchRequest)countSearchRequest, this._getSearchRequest(searchContext), searchContext, query);
        return countSearchRequest;
    }

    protected SearchSearchRequest createSearchSearchRequest(SearchContext searchContext, Query query, int start, int end) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        SearchRequest searchRequest = this._getSearchRequest(searchContext);
        this.populateBaseSearchRequest((BaseSearchRequest)searchSearchRequest, searchRequest, searchContext, query);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        searchSearchRequest.setAllFieldsSelected(queryConfig.isAllFieldsSelected());
        searchSearchRequest.setAlternateUidFieldName(queryConfig.getAlternateUidFieldName());
        searchSearchRequest.setGroupBy(searchContext.getGroupBy());
        searchSearchRequest.setGroupByRequests((Collection)searchRequest.getGroupByRequests());
        searchSearchRequest.setHighlightEnabled(queryConfig.isHighlightEnabled());
        searchSearchRequest.setHighlightFieldNames(queryConfig.getHighlightFieldNames());
        searchSearchRequest.setHighlightFragmentSize(queryConfig.getHighlightFragmentSize());
        searchSearchRequest.setHighlightRequireFieldMatch(queryConfig.isHighlightRequireFieldMatch());
        searchSearchRequest.setHighlightSnippetSize(queryConfig.getHighlightSnippetSize());
        searchSearchRequest.setIncludeResponseString(searchRequest.isIncludeResponseString());
        searchSearchRequest.setLocale(queryConfig.getLocale());
        searchSearchRequest.setLuceneSyntax(GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax")));
        if (query != null) {
            searchSearchRequest.setPostFilter(query.getPostFilter());
        }
        searchSearchRequest.setScoreEnabled(queryConfig.isScoreEnabled());
        searchSearchRequest.setSelectedFieldNames(queryConfig.getSelectedFieldNames());
        searchSearchRequest.setSize(Integer.valueOf(end - start));
        searchSearchRequest.setSorts(searchContext.getSorts());
        searchSearchRequest.setSorts((Collection)searchRequest.getSorts());
        searchSearchRequest.setStart(Integer.valueOf(start));
        searchSearchRequest.setStats(searchContext.getStats());
        return searchSearchRequest;
    }

    protected QuerySuggester getQuerySuggester() {
        return this._querySuggester;
    }

    protected void populateBaseSearchRequest(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest, SearchContext searchContext, Query query) {
        baseSearchRequest.putAllFacets(searchContext.getFacets());
        baseSearchRequest.setBasicFacetSelection(GetterUtil.getBoolean((Object)searchContext.getAttribute("search.basic.facet.selection")));
        baseSearchRequest.setExplain(Boolean.valueOf(searchRequest.isExplain()));
        baseSearchRequest.setIncludeResponseString(searchRequest.isIncludeResponseString());
        baseSearchRequest.setIndexNames(new String[]{this._defaultCollection});
        long companyId = searchContext.getCompanyId();
        if (companyId >= 0L && query != null) {
            BooleanFilter preBooleanFilter = query.getPreBooleanFilter();
            if (preBooleanFilter == null) {
                preBooleanFilter = new BooleanFilter();
            }
            preBooleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
            query.setPreBooleanFilter(preBooleanFilter);
        }
        baseSearchRequest.setStatsRequests((Collection)searchRequest.getStatsRequests());
        this.setLegacyQuery(baseSearchRequest, query);
        this.setQuery(baseSearchRequest, searchRequest);
    }

    protected void populateResponse(BaseSearchResponse baseSearchResponse, SearchResponseBuilder searchResponseBuilder) {
        searchResponseBuilder.count(baseSearchResponse.getCount()).requestString(baseSearchResponse.getSearchRequestString()).responseString(baseSearchResponse.getSearchResponseString()).searchTimeValue(baseSearchResponse.getSearchTimeValue()).statsResponseMap(baseSearchResponse.getStatsResponseMap());
    }

    protected void populateResponse(SearchSearchResponse searchSearchResponse, SearchResponseBuilder searchResponseBuilder) {
        this.populateResponse((BaseSearchResponse)searchSearchResponse, searchResponseBuilder);
        searchResponseBuilder.groupByResponses(searchSearchResponse.getGroupByResponses());
    }

    protected void setLegacyQuery(BaseSearchRequest baseSearchRequest, Query query) {
        baseSearchRequest.setQuery(query);
    }

    protected void setQuery(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        baseSearchRequest.setQuery(searchRequest.getQuery());
    }

    private SearchRequest _getSearchRequest(SearchContext searchContext) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder(searchContext);
        return searchRequestBuilder.build();
    }

    private SearchResponseBuilder _getSearchResponseBuilder(SearchContext searchContext) {
        return this._searchResponseBuilderFactory.builder(searchContext);
    }
}

