/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.rest.pagination;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@JacksonXmlRootElement(localName="page")
public class SearchPage<T>
extends Page<T> {
    private final Object _aggregations;
    private final Object _searchFacets;

    public static <T> SearchPage<T> of(Map<String, Map<String, String>> actions, Object aggregations, Object searchFacets, Collection<T> items, Pagination pagination, long totalCount) {
        return new SearchPage<T>(actions, aggregations, searchFacets, items, pagination, totalCount);
    }

    @JsonProperty(value="aggregations")
    public Object getAggregations() {
        return this._aggregations;
    }

    @JsonProperty(value="searchFacets")
    public Object getSearchFacets() {
        return this._searchFacets;
    }

    public String toString() {
        StringBundler sb = new StringBundler("{\"actions\": ");
        sb.append(this._toString(this.getActions()));
        sb.append(", \"aggregations\": ");
        sb.append(this._toString((Map)this._aggregations));
        sb.append(", \"searchFacets\": ");
        sb.append(this._toString((Map)this._searchFacets));
        sb.append(", \"items\": [");
        Collection items = this.getItems();
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("], \"page\": ");
        sb.append(this.getPage());
        sb.append(", \"pageSize\": ");
        sb.append(this.getPageSize());
        sb.append(", \"totalCount\": ");
        sb.append(this.getTotalCount());
        sb.append("}");
        return sb.toString();
    }

    private SearchPage(Map<String, Map<String, String>> actions, Object aggregations, Object searchFacets, Collection<T> items, Pagination pagination, long totalCount) {
        super(actions, null, items, pagination, totalCount);
        this._aggregations = aggregations;
        this._searchFacets = searchFacets;
    }

    private String _toString(Map<String, Object> map) {
        if (map == null) {
            return "{}";
        }
        StringBundler sb = new StringBundler("{");
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (value instanceof Map) {
                sb.append(this._toString((Map)value));
            } else {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

