/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.learning.to.rank.internal.searcher;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.search.learning.to.rank.configuration.LearningToRankConfiguration;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.rescore.RescoreBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.spi.searcher.SearchRequestContributor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.learning.to.rank.configuration.LearningToRankConfiguration"}, enabled=false, property={"search.request.contributor.id=com.liferay.portal.search.learning.to.rank"}, service={SearchRequestContributor.class})
public class LearningToRankSearchRequestContributor
implements SearchRequestContributor {
    @Reference
    protected Queries queries;
    @Reference
    protected RescoreBuilderFactory rescoreBuilderFactory;
    @Reference
    protected SearchRequestBuilderFactory searchRequestBuilderFactory;
    private volatile boolean _enabled;
    private volatile String _model;

    public SearchRequest contribute(SearchRequest searchRequest) {
        if (!this._enabled) {
            return searchRequest;
        }
        SearchRequestBuilder searchRequestBuilder = this.searchRequestBuilderFactory.builder(searchRequest);
        searchRequestBuilder.rescores(this._getRescores(searchRequest));
        return searchRequestBuilder.build();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        LearningToRankConfiguration learningToRankConfiguration = (LearningToRankConfiguration)ConfigurableUtil.createConfigurable(LearningToRankConfiguration.class, properties);
        this._enabled = learningToRankConfiguration.enabled();
        this._model = learningToRankConfiguration.model();
    }

    private Query _getRescoreQuery(String model, String keywords) {
        return this.queries.wrapper(JSONUtil.put((String)"sltr", (Object)JSONUtil.put((String)"model", (Object)model).put("params", JSONUtil.put((String)"keywords", (Object)keywords))).toString());
    }

    private List<Rescore> _getRescores(SearchRequest searchRequest) {
        return Arrays.asList(this.rescoreBuilderFactory.builder(this._getRescoreQuery(this._model, searchRequest.getQueryString())).windowSize(Integer.valueOf(1000)).build());
    }
}

