/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.engine.adapter.search;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.engine.adapter.search.SearchResponse;
import com.liferay.portal.search.searcher.SearchTimeValue;
import com.liferay.portal.search.stats.StatsResponse;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseSearchResponse
implements SearchResponse {
    private final Map<String, AggregationResult> _aggregationResultsMap = new LinkedHashMap<String, AggregationResult>();
    private long _count;
    private Map<String, String> _executionProfile;
    private long _executionTime;
    private String _pointInTimeId;
    private String _scrollId;
    private String _searchRequestString;
    private String _searchResponseString;
    private SearchTimeValue _searchTimeValue;
    private final Map<String, StatsResponse> _statsResponseMap = new LinkedHashMap<String, StatsResponse>();
    private boolean _terminatedEarly;
    private boolean _timedOut;

    public void addAggregationResult(AggregationResult aggregationResult) {
        this._aggregationResultsMap.put(aggregationResult.getName(), aggregationResult);
    }

    public void addStatsResponse(StatsResponse statsResponse) {
        this._statsResponseMap.put(statsResponse.getField(), statsResponse);
    }

    public Map<String, AggregationResult> getAggregationResultsMap() {
        return Collections.unmodifiableMap(this._aggregationResultsMap);
    }

    public long getCount() {
        return this._count;
    }

    public Map<String, String> getExecutionProfile() {
        return this._executionProfile;
    }

    public long getExecutionTime() {
        return this._executionTime;
    }

    public String getPointInTimeId() {
        return this._pointInTimeId;
    }

    public String getSearchRequestString() {
        return this._searchRequestString;
    }

    public String getSearchResponseString() {
        return this._searchResponseString;
    }

    public SearchTimeValue getSearchTimeValue() {
        return this._searchTimeValue;
    }

    public Map<String, StatsResponse> getStatsResponseMap() {
        return Collections.unmodifiableMap(this._statsResponseMap);
    }

    public boolean isTerminatedEarly() {
        return this._terminatedEarly;
    }

    public boolean isTimedOut() {
        return this._timedOut;
    }

    public void setCount(long count) {
        this._count = count;
    }

    public void setExecutionProfile(Map<String, String> executionProfile) {
        this._executionProfile = executionProfile;
    }

    public void setExecutionTime(long executionTime) {
        this._executionTime = executionTime;
    }

    public void setPointInTimeId(String pointInTimeId) {
        this._pointInTimeId = pointInTimeId;
    }

    public void setScrollId(String scrollId) {
        this._scrollId = scrollId;
    }

    public void setSearchRequestString(String searchRequestString) {
        this._searchRequestString = searchRequestString;
    }

    public void setSearchResponseString(String searchResponseString) {
        this._searchResponseString = searchResponseString;
    }

    public void setSearchTimeValue(SearchTimeValue searchTimeValue) {
        this._searchTimeValue = searchTimeValue;
    }

    public void setTerminatedEarly(boolean terminatedEarly) {
        this._terminatedEarly = terminatedEarly;
    }

    public void setTimedOut(boolean timedOut) {
        this._timedOut = timedOut;
    }
}

