/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.engine.adapter.index;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.engine.adapter.ccr.CrossClusterRequest;
import com.liferay.portal.search.engine.adapter.index.AnalyzeIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequestExecutor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AnalyzeIndexRequest
extends CrossClusterRequest
implements IndexRequest<AnalyzeIndexResponse> {
    private String _analyzer;
    private Set<String> _attributes;
    private Set<String> _charFilters;
    private boolean _explain;
    private String _fieldName;
    private String _indexName;
    private String _normalizer;
    private String[] _texts;
    private Set<String> _tokenFilters;
    private String _tokenizer;

    public AnalyzeIndexRequest() {
        this.setPreferLocalCluster(true);
    }

    @Override
    public AnalyzeIndexResponse accept(IndexRequestExecutor indexRequestExecutor) {
        return indexRequestExecutor.executeIndexRequest(this);
    }

    public void addAttributes(String ... attributes) {
        if (this._attributes == null) {
            this._attributes = new HashSet<String>();
        }
        Collections.addAll(this._attributes, attributes);
    }

    public void addCharFilters(String ... charFilters) {
        if (ArrayUtil.isEmpty((Object[])charFilters)) {
            return;
        }
        if (this._charFilters == null) {
            this._charFilters = new HashSet<String>();
        }
        Collections.addAll(this._charFilters, charFilters);
    }

    public void addTokenFilter(String ... tokenFilters) {
        if (this._tokenFilters == null) {
            this._tokenFilters = new HashSet<String>();
        }
        Collections.addAll(this._tokenFilters, tokenFilters);
    }

    public String getAnalyzer() {
        return this._analyzer;
    }

    public Set<String> getAttributes() {
        if (this._attributes == null) {
            return Collections.emptySet();
        }
        return this._attributes;
    }

    public String[] getAttributesArray() {
        if (SetUtil.isEmpty(this._attributes)) {
            return StringPool.EMPTY_ARRAY;
        }
        return this._attributes.toArray(new String[0]);
    }

    public Set<String> getCharFilters() {
        if (this._charFilters == null) {
            return Collections.emptySet();
        }
        return this._charFilters;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public String getIndexName() {
        return this._indexName;
    }

    @Override
    public String[] getIndexNames() {
        return new String[]{this._indexName};
    }

    public String getNormalizer() {
        return this._normalizer;
    }

    public String[] getTexts() {
        return this._texts;
    }

    public Set<String> getTokenFilters() {
        if (this._tokenFilters == null) {
            return Collections.emptySet();
        }
        return this._tokenFilters;
    }

    public String getTokenizer() {
        return this._tokenizer;
    }

    public boolean isExplain() {
        return this._explain;
    }

    public void setAnalyzer(String analyzer) {
        this._analyzer = analyzer;
    }

    public void setAttributes(Set<String> attributes) {
        this._attributes = attributes;
    }

    public void setCharFilters(Set<String> charFilters) {
        this._charFilters = charFilters;
    }

    public void setExplain(boolean explain) {
        this._explain = explain;
    }

    public void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    public void setIndexName(String indexName) {
        this._indexName = indexName;
    }

    public void setNormalizer(String normalizer) {
        this._normalizer = normalizer;
    }

    public void setTexts(String ... texts) {
        this._texts = texts;
    }

    public void setTokenFilters(Set<String> tokenFilters) {
        this._tokenFilters = tokenFilters;
    }

    public void setTokenizer(String tokenizer) {
        this._tokenizer = tokenizer;
    }
}

