/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.stats.StatsRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseSearchRequest {
    private final Map<String, Aggregation> _aggregationsMap = new LinkedHashMap<String, Aggregation>();
    private boolean _basicFacetSelection;
    private final List<ComplexQueryPart> _complexQueryParts = new ArrayList<ComplexQueryPart>();
    private Boolean _explain;
    private final Map<String, Facet> _facets = new LinkedHashMap<String, Facet>();
    private boolean _includeResponseString;
    private final Map<String, Float> _indexBoosts = new LinkedHashMap<String, Float>();
    private String[] _indexNames;
    private com.liferay.portal.kernel.search.Query _legacyQuery;
    private Float _minimumScore;
    private final Map<String, PipelineAggregation> _pipelineAggregationsMap = new LinkedHashMap<String, PipelineAggregation>();
    private Filter _postFilter;
    private Query _postFilterQuery;
    private Query _query;
    private Boolean _requestCache;
    private Query _rescoreQuery;
    private List<Rescore> _rescores;
    private List<StatsRequest> _statsRequests = Collections.emptyList();
    private Long _timeoutInMilliseconds;
    private Boolean _trackTotalHits;
    private String[] _types;

    public void addAggregation(Aggregation aggregation) {
        this._aggregationsMap.put(aggregation.getName(), aggregation);
    }

    public void addComplexQueryParts(Collection<ComplexQueryPart> complexQueryParts) {
        this._complexQueryParts.addAll(complexQueryParts);
    }

    public void addIndexBoost(String index, float boost) {
        this._indexBoosts.put(index, Float.valueOf(boost));
    }

    public void addPipelineAggregation(PipelineAggregation pipelineAggregation) {
        this._pipelineAggregationsMap.put(pipelineAggregation.getName(), pipelineAggregation);
    }

    public Map<String, Aggregation> getAggregationsMap() {
        return Collections.unmodifiableMap(this._aggregationsMap);
    }

    public List<ComplexQueryPart> getComplexQueryParts() {
        return Collections.unmodifiableList(this._complexQueryParts);
    }

    public Boolean getExplain() {
        return this._explain;
    }

    public Map<String, Facet> getFacets() {
        return this._facets;
    }

    public Map<String, Float> getIndexBoosts() {
        return Collections.unmodifiableMap(this._indexBoosts);
    }

    public String[] getIndexNames() {
        return this._indexNames;
    }

    public Float getMinimumScore() {
        return this._minimumScore;
    }

    public Map<String, PipelineAggregation> getPipelineAggregationsMap() {
        return Collections.unmodifiableMap(this._pipelineAggregationsMap);
    }

    public Filter getPostFilter() {
        return this._postFilter;
    }

    public Query getPostFilterQuery() {
        return this._postFilterQuery;
    }

    public Query getQuery() {
        return this._query;
    }

    public com.liferay.portal.kernel.search.Query getQuery71() {
        return this._legacyQuery;
    }

    public Boolean getRequestCache() {
        return this._requestCache;
    }

    @Deprecated
    public Query getRescoreQuery() {
        return this._rescoreQuery;
    }

    public List<Rescore> getRescores() {
        return this._rescores;
    }

    public List<StatsRequest> getStatsRequests() {
        return Collections.unmodifiableList(this._statsRequests);
    }

    public Long getTimeoutInMilliseconds() {
        return this._timeoutInMilliseconds;
    }

    public Boolean getTrackTotalHits() {
        return this._trackTotalHits;
    }

    public String[] getTypes() {
        return this._types;
    }

    public boolean isBasicFacetSelection() {
        return this._basicFacetSelection;
    }

    public boolean isExplain() {
        if (this._explain != null) {
            return this._explain;
        }
        return false;
    }

    public boolean isIncludeResponseString() {
        return this._includeResponseString;
    }

    public boolean isRequestCache() {
        if (this._requestCache != null) {
            return this._requestCache;
        }
        return false;
    }

    public boolean isTrackTotalHits() {
        if (this._trackTotalHits != null) {
            return this._trackTotalHits;
        }
        return false;
    }

    public void putAllFacets(Map<String, Facet> facets) {
        this._facets.putAll(facets);
    }

    public void putFacet(String fieldName, Facet facet) {
        this._facets.put(fieldName, facet);
    }

    public void setBasicFacetSelection(boolean basicFacetSelection) {
        this._basicFacetSelection = basicFacetSelection;
    }

    public void setExplain(Boolean explain) {
        this._explain = explain;
    }

    public void setIncludeResponseString(boolean includeResponseString) {
        this._includeResponseString = includeResponseString;
    }

    public void setIndexNames(String ... indexNames) {
        this._indexNames = indexNames;
    }

    public void setMinimumScore(Float minimumScore) {
        this._minimumScore = minimumScore;
    }

    public void setPostFilter(Filter postFilter) {
        this._postFilter = postFilter;
    }

    public void setPostFilterQuery(Query postFilterQuery) {
        this._postFilterQuery = postFilterQuery;
    }

    public void setQuery(com.liferay.portal.kernel.search.Query legacyQuery) {
        this._legacyQuery = legacyQuery;
    }

    public void setQuery(Query query) {
        this._query = query;
    }

    public void setRequestCache(Boolean requestCache) {
        this._requestCache = requestCache;
    }

    @Deprecated
    public void setRescoreQuery(Query rescoreQuery) {
        this._rescoreQuery = rescoreQuery;
    }

    public void setRescores(List<Rescore> rescores) {
        this._rescores = rescores;
    }

    public void setStatsRequests(Collection<StatsRequest> statsRequests) {
        this._statsRequests = new ArrayList<StatsRequest>(statsRequests);
    }

    public void setTimeoutInMilliseconds(Long timeoutInMilliseconds) {
        this._timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public void setTrackTotalHits(Boolean trackTotalHits) {
        this._trackTotalHits = trackTotalHits;
    }

    public void setTypes(String ... types) {
        this._types = types;
    }
}

