/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OSDetector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UncompressUtil {
    private static final int _CHARS_BUFFER_SIZE = 8192;
    private static final Log _log = LogFactoryUtil.getLog(UncompressUtil.class);

    /*
     * Exception decompiling
     */
    public static String unarchive(Path tarGzFilePath, Path destinationDirectoryPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void unzip(Path zipFilePath, Path destinationDirectoryPath) throws IOException {
        Files.createDirectories(destinationDirectoryPath, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(zipFilePath, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (UncompressUtil._isZipSlipVulnerable(destinationDirectoryPath, zipEntry.getName())) continue;
                Path path = destinationDirectoryPath.resolve(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectory(path, new FileAttribute[0]);
                } else {
                    Files.copy(zipInputStream, path, new CopyOption[0]);
                }
                UncompressUtil._setFilePermission(path);
            }
        }
    }

    private static boolean _isZipSlipVulnerable(Path destinationPath, String tarArchiveEntryName) throws IOException {
        File canonicalDirectoryFile = destinationPath.toFile();
        String canonicalDirectoryPath = canonicalDirectoryFile.getCanonicalPath();
        File destinationFile = new File(destinationPath.toFile(), tarArchiveEntryName);
        String canonicalDestinationFile = destinationFile.getCanonicalPath();
        if (!canonicalDestinationFile.startsWith(canonicalDirectoryPath + File.separator)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Entry ", tarArchiveEntryName, " is outside of the target directory ", canonicalDirectoryPath}));
            }
            return true;
        }
        return false;
    }

    private static void _setFilePermission(Path path) throws IOException {
        if (OSDetector.isWindows()) {
            File file = path.toFile();
            file.setExecutable(true);
            file.setReadable(true);
            file.setWritable(true);
        } else {
            Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxrwxrwx"));
        }
    }
}

