/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.response;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.SearchHitDocumentTranslator;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetCollectorFactory;
import com.liferay.portal.search.elasticsearch7.internal.facet.FacetUtil;
import com.liferay.portal.search.elasticsearch7.internal.search.response.HitsImpl;
import com.liferay.portal.search.elasticsearch7.internal.search.response.SearchResponseTranslator;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.groupby.GroupByResponse;
import com.liferay.portal.search.groupby.GroupByResponseFactory;
import com.liferay.portal.search.legacy.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.legacy.stats.StatsResultsTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchResponseTranslator.class})
public class DefaultSearchResponseTranslator
implements SearchResponseTranslator {
    @Reference
    private GroupByResponseFactory _groupByResponseFactory;
    @Reference
    private SearchHitDocumentTranslator _searchHitDocumentTranslator;
    @Reference
    private StatsRequestBuilderFactory _statsRequestBuilderFactory;
    @Reference
    private StatsResultsTranslator _statsResultsTranslator;
    @Reference
    private StatsTranslator _statsTranslator;

    @Override
    public void populate(SearchSearchResponse searchSearchResponse, SearchResponse searchResponse, SearchSearchRequest searchSearchRequest) {
        SearchHits searchHits = searchResponse.getHits();
        HitsImpl hits = new HitsImpl();
        this._updateFacetCollectors(searchResponse, searchSearchRequest.getFacets());
        this._updateGroupedHits(searchSearchResponse, searchResponse, searchSearchRequest, (Hits)hits, searchSearchRequest.getAlternateUidFieldName(), searchSearchRequest.getLocale());
        this._updateStatsResults((Hits)hits, searchResponse.getAggregations(), (Map<String, Stats>)searchSearchRequest.getStats());
        TimeValue timeValue = searchResponse.getTook();
        hits.setSearchTime((float)timeValue.getSecondsFrac());
        this._processSearchHits(searchHits, hits, searchSearchRequest.getAlternateUidFieldName(), searchSearchRequest.getLocale());
        searchSearchResponse.setHits((Hits)hits);
    }

    protected StatsResults getStatsResults(Map<String, Aggregation> aggregationsMap, Stats stats) {
        return this._statsResultsTranslator.translate(this._statsTranslator.translateResponse(aggregationsMap, this._translate(stats)));
    }

    private void _addSnippets(Document document, Map<String, HighlightField> highlightFields, String fieldName, Locale locale) {
        HighlightField highlightField;
        String snippetFieldName = fieldName;
        if (!fieldName.startsWith("nestedFieldArray.")) {
            snippetFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        }
        if ((highlightField = highlightFields.get(snippetFieldName)) == null) {
            highlightField = highlightFields.get(fieldName);
            snippetFieldName = fieldName;
        }
        if (highlightField == null) {
            return;
        }
        Object[] array = highlightField.fragments();
        document.add(new Field(StringBundler.concat((String[])new String[]{"snippet", "_", snippetFieldName}), StringUtil.merge((Object[])array, (String)"...")));
    }

    private void _addSnippets(SearchHit hit, Document document, Locale locale) {
        Map highlightFields = hit.getHighlightFields();
        if (MapUtil.isEmpty((Map)highlightFields)) {
            return;
        }
        highlightFields.forEach((fieldName, highlightField) -> this._addSnippets(document, highlightFields, (String)fieldName, locale));
    }

    private FacetCollector _getFacetCollector(Facet facet, Map<String, Aggregation> aggregationsMap) {
        FacetCollectorFactory facetCollectorFactory = new FacetCollectorFactory();
        return facetCollectorFactory.getFacetCollector(aggregationsMap.get(FacetUtil.getAggregationName(facet)));
    }

    private void _populateUID(Document document, String alternateUidFieldName) {
        Field uidField = document.getField("uid");
        if (uidField != null || Validator.isNull((String)alternateUidFieldName)) {
            return;
        }
        String uidValue = document.get(alternateUidFieldName);
        if (Validator.isNotNull((String)uidValue)) {
            uidField = new Field("uid", uidValue);
            document.add(uidField);
        }
    }

    private Document _processSearchHit(SearchHit searchHit, String alternateUidFieldName) {
        Document document = this._searchHitDocumentTranslator.translate(searchHit);
        this._populateUID(document, alternateUidFieldName);
        return document;
    }

    private Hits _processSearchHits(SearchHits searchHits, Hits hits, String alternateUidFieldName, Locale locale) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        TotalHits totalHits = searchHits.getTotalHits();
        if (totalHits.value > 0L) {
            SearchHit[] searchHitsArray;
            for (SearchHit searchHit : searchHitsArray = searchHits.getHits()) {
                Document document = this._processSearchHit(searchHit, alternateUidFieldName);
                documents.add(document);
                scores.add(Float.valueOf(searchHit.getScore()));
                this._addSnippets(searchHit, document, locale);
            }
        }
        hits.setDocs(documents.toArray(new Document[0]));
        hits.setLength((int)totalHits.value);
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        return hits;
    }

    private StatsRequest _translate(Stats stats) {
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder(stats);
        return statsRequestBuilder.build();
    }

    private void _updateFacetCollectors(SearchResponse searchResponse, Map<String, Facet> facetsMap) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        for (Facet facet : facetsMap.values()) {
            if (facet.isStatic()) continue;
            facet.setFacetCollector(this._getFacetCollector(facet, aggregationsMap));
        }
    }

    private void _updateGroupedHits(SearchSearchResponse searchSearchResponse, SearchResponse searchResponse, SearchSearchRequest searchSearchRequest, Hits hits, String alternateUidFieldName, Locale locale) {
        GroupBy groupBy;
        List groupByRequests = searchSearchRequest.getGroupByRequests();
        if (ListUtil.isNotEmpty((List)groupByRequests)) {
            for (GroupByRequest groupByRequest : groupByRequests) {
                this._updateGroupedHits(searchSearchResponse, searchResponse, groupByRequest.getField(), hits, alternateUidFieldName, locale);
            }
        }
        if ((groupBy = searchSearchRequest.getGroupBy()) != null) {
            this._updateGroupedHits(searchSearchResponse, searchResponse, groupBy.getField(), hits, alternateUidFieldName, locale);
        }
    }

    private void _updateGroupedHits(SearchSearchResponse searchSearchResponse, SearchResponse searchResponse, String field, Hits hits, String alternateUidFieldName, Locale locale) {
        Aggregations aggregations = searchResponse.getAggregations();
        Map aggregationsMap = aggregations.getAsMap();
        Terms terms = (Terms)aggregationsMap.get("GroupBy_" + field);
        List buckets = terms.getBuckets();
        GroupByResponse groupByResponse = this._groupByResponseFactory.getGroupByResponse(field);
        searchSearchResponse.addGroupByResponse(groupByResponse);
        for (Terms.Bucket bucket : buckets) {
            Aggregations bucketAggregations = bucket.getAggregations();
            TopHits topHits = (TopHits)bucketAggregations.get("_topHits");
            SearchHits groupedSearchHits = topHits.getHits();
            HitsImpl groupedHits = new HitsImpl();
            this._processSearchHits(groupedSearchHits, groupedHits, alternateUidFieldName, locale);
            TotalHits totalHits = groupedSearchHits.getTotalHits();
            groupedHits.setLength((int)totalHits.value);
            hits.addGroupedHits(bucket.getKeyAsString(), (Hits)groupedHits);
            groupByResponse.putHits(bucket.getKeyAsString(), (Hits)groupedHits);
        }
    }

    private void _updateStatsResults(Hits hits, Aggregations aggregations, Map<String, Stats> statsMap) {
        if (aggregations != null) {
            this._updateStatsResults(hits, aggregations.getAsMap(), statsMap);
        }
    }

    private void _updateStatsResults(Hits hits, Map<String, Aggregation> aggregationsMap, Map<String, Stats> statsMap) {
        if (MapUtil.isNotEmpty(statsMap)) {
            for (Stats stats : statsMap.values()) {
                hits.addStatsResults(this.getStatsResults(aggregationsMap, stats));
            }
        }
    }
}

