/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.GetSnapshotRepositoriesRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesResponse;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotRepositoryDetails;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetSnapshotRepositoriesRequestExecutor.class})
public class GetSnapshotRepositoriesRequestExecutorImpl
implements GetSnapshotRepositoriesRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(GetSnapshotRepositoriesRequestExecutorImpl.class);
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetSnapshotRepositoriesResponse execute(GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest) {
        GetSnapshotRepositoriesResponse getSnapshotRepositoriesResponse;
        block2: {
            GetRepositoriesRequest getRepositoriesRequest = this.createGetRepositoriesRequest(getSnapshotRepositoriesRequest);
            getSnapshotRepositoriesResponse = new GetSnapshotRepositoriesResponse();
            try {
                GetRepositoriesResponse elasticsearchGetRepositoriesResponse = this._getGetRepositoriesResponse(getRepositoriesRequest, getSnapshotRepositoriesRequest);
                List repositoriesMetadatas = elasticsearchGetRepositoriesResponse.repositories();
                repositoriesMetadatas.forEach(repositoryMetadata -> {
                    Settings repositoryMetadataSettings = repositoryMetadata.settings();
                    SnapshotRepositoryDetails snapshotRepositoryDetails = new SnapshotRepositoryDetails(repositoryMetadata.name(), repositoryMetadata.type(), repositoryMetadataSettings.toString());
                    getSnapshotRepositoriesResponse.addSnapshotRepositoryMetadata(snapshotRepositoryDetails);
                });
            }
            catch (RepositoryMissingException repositoryMissingException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)repositoryMissingException);
            }
        }
        return getSnapshotRepositoriesResponse;
    }

    protected GetRepositoriesRequest createGetRepositoriesRequest(GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest) {
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest();
        getRepositoriesRequest.repositories(getSnapshotRepositoriesRequest.getRepositoryNames());
        return getRepositoriesRequest;
    }

    private GetRepositoriesResponse _getGetRepositoriesResponse(GetRepositoriesRequest getRepositoriesRequest, GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getSnapshotRepositoriesRequest.getConnectionId(), getSnapshotRepositoriesRequest.isPreferLocalCluster());
        SnapshotClient snapshotClient = restHighLevelClient.snapshot();
        try {
            return snapshotClient.getRepository(getRepositoriesRequest, RequestOptions.DEFAULT);
        }
        catch (ElasticsearchStatusException elasticsearchStatusException) {
            String message = elasticsearchStatusException.getMessage();
            if (message.contains("type=repository_missing_exception")) {
                throw new RepositoryMissingException(StringUtils.substringBetween((String)message, (String)"reason=[", (String)"] missing"));
            }
            throw elasticsearchStatusException;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

