/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlightTranslator;
import com.liferay.portal.search.elasticsearch7.internal.highlight.HighlighterTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.QueryToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchSourceBuilderAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch7.internal.sort.SortTranslator;
import com.liferay.portal.search.elasticsearch7.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.legacy.groupby.GroupByRequestFactory;
import com.liferay.portal.search.legacy.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldTranslator;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchRequestAssembler.class})
public class SearchSearchRequestAssemblerImpl
implements SearchSearchRequestAssembler {
    @Reference
    private CommonSearchSourceBuilderAssembler _commonSearchSourceBuilderAssembler;
    @Reference
    private GroupByRequestFactory _groupByRequestFactory;
    @Reference
    private GroupByTranslator _groupByTranslator;
    @Reference
    private HighlighterTranslator _highlighterTranslator;
    private final HighlightTranslator _highlightTranslator = new HighlightTranslator();
    @Reference
    private QueryToQueryBuilderTranslator _queryToQueryBuilderTranslator;
    @Reference
    private SortFieldTranslator<SortBuilder<?>> _sortFieldTranslator;
    @Reference
    private SortTranslator _sortTranslator;
    @Reference
    private StatsRequestBuilderFactory _statsRequestBuilderFactory;
    @Reference
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest, SearchRequest searchRequest) {
        this._commonSearchSourceBuilderAssembler.assemble(searchSourceBuilder, (BaseSearchRequest)searchSearchRequest, searchRequest);
        this._setFetchSource(searchSourceBuilder, searchSearchRequest);
        this._setGroupBy(searchSourceBuilder, searchSearchRequest);
        this._setGroupByRequests(searchSourceBuilder, searchSearchRequest);
        this._setHighlighter(searchSourceBuilder, searchSearchRequest);
        this._setPagination(searchSourceBuilder, searchSearchRequest);
        this._setPreference(searchRequest, searchSearchRequest);
        this._setSorts(searchSourceBuilder, searchSearchRequest);
        this._setStats(searchSourceBuilder, searchSearchRequest);
        this._setStoredFields(searchSourceBuilder, searchSearchRequest);
        this._setTrackScores(searchSourceBuilder, searchSearchRequest);
        this._setVersion(searchSourceBuilder, searchSearchRequest);
        searchRequest.source(searchSourceBuilder);
    }

    protected GroupByRequest translate(GroupBy groupBy) {
        return this._groupByRequestFactory.getGroupByRequest(groupBy);
    }

    protected StatsRequest translate(Stats stats) {
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder(stats);
        return statsRequestBuilder.build();
    }

    private void _setFetchSource(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getFetchSource() != null || searchSearchRequest.getFetchSourceExcludes() != null || searchSearchRequest.getFetchSourceIncludes() != null) {
            if (searchSearchRequest.getFetchSource() == null) {
                searchSourceBuilder.fetchSource(true);
            } else {
                searchSourceBuilder.fetchSource(searchSearchRequest.getFetchSource().booleanValue());
            }
            searchSourceBuilder.fetchSource(searchSearchRequest.getFetchSourceIncludes(), searchSearchRequest.getFetchSourceExcludes());
        }
    }

    private void _setGroupBy(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getGroupBy() != null) {
            this._groupByTranslator.translate(searchSourceBuilder, this.translate(searchSearchRequest.getGroupBy()), searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize());
        }
    }

    private void _setGroupByRequests(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        List groupByRequests = searchSearchRequest.getGroupByRequests();
        if (ListUtil.isNotEmpty((List)groupByRequests)) {
            groupByRequests.forEach(groupByRequest -> this._groupByTranslator.translate(searchSourceBuilder, (GroupByRequest)groupByRequest, searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize()));
        }
    }

    private void _setHighlighter(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getHighlight() != null) {
            searchSourceBuilder.highlighter(this._highlightTranslator.translate(searchSearchRequest.getHighlight(), this._queryToQueryBuilderTranslator));
        } else if (searchSearchRequest.isHighlightEnabled()) {
            this._highlighterTranslator.translate(searchSourceBuilder, searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize(), searchSearchRequest.isLuceneSyntax());
        }
    }

    private void _setPagination(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getStart() != null) {
            searchSourceBuilder.from(searchSearchRequest.getStart().intValue());
        }
        if (searchSearchRequest.getSize() != null) {
            searchSourceBuilder.size(searchSearchRequest.getSize().intValue());
        }
    }

    private void _setPreference(SearchRequest searchRequest, SearchSearchRequest searchSearchRequest) {
        String preference = searchSearchRequest.getPreference();
        if (!Validator.isBlank((String)preference)) {
            searchRequest.preference(preference);
        }
    }

    private void _setSorts(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        for (Sort sort : searchSearchRequest.getSorts()) {
            searchSourceBuilder.sort((SortBuilder)this._sortFieldTranslator.translate(sort));
        }
        this._sortTranslator.translate(searchSourceBuilder, searchSearchRequest.getSorts71());
    }

    private void _setStats(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        Map statsMap = searchSearchRequest.getStats();
        if (MapUtil.isNotEmpty((Map)statsMap)) {
            statsMap.forEach((key, stats) -> this._statsTranslator.populateRequest(searchSourceBuilder, this.translate((Stats)stats)));
        }
    }

    private void _setStoredFields(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        Object[] selectedFieldNames = searchSearchRequest.getSelectedFieldNames();
        if (!ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            searchSourceBuilder.storedFields(ListUtil.fromArray((Object[])selectedFieldNames));
        } else {
            searchSourceBuilder.storedField("*");
        }
    }

    private void _setTrackScores(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getScoreEnabled() != null) {
            searchSourceBuilder.trackScores(searchSearchRequest.getScoreEnabled().booleanValue());
        }
    }

    private void _setVersion(SearchSourceBuilder searchSourceBuilder, SearchSearchRequest searchSearchRequest) {
        if (searchSearchRequest.getVersion() != null) {
            searchSourceBuilder.version(searchSearchRequest.getVersion());
        }
    }
}

